/*
 * Decompiled with CFR 0.152.
 */
package appeng.libs.micromark;

import appeng.libs.micromark.NamedCharacterEntities;
import appeng.libs.micromark.html.NumericCharacterReference;
import java.util.Objects;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

public final class DecodeString {
    private static final Pattern characterEscapeOrReference = Pattern.compile("\\\\([!-/:-@\\[-`{-~])|&(#(?:\\d{1,7}|x[\\da-f]{1,6})|[\\da-z]{1,31});", 2);

    public static String decodeString(String text) {
        return characterEscapeOrReference.matcher(text).replaceAll(DecodeString::decode);
    }

    private static String decode(MatchResult result) {
        String escape = result.group(1);
        if (escape != null) {
            return escape;
        }
        String charRef = result.group(2);
        char head = charRef.charAt(0);
        if (head == '#') {
            head = charRef.charAt(1);
            boolean hex = head == 'x' || head == 'X';
            return NumericCharacterReference.decodeNumericCharacterReference(charRef.substring(hex ? 2 : 1), hex ? 16 : 10);
        }
        return Objects.requireNonNullElse(NamedCharacterEntities.decodeNamedCharacterReference(charRef), result.group());
    }
}

