/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.indices;

import appeng.client.guidebook.PageAnchor;
import appeng.client.guidebook.compiler.ParsedGuidePage;
import appeng.client.guidebook.indices.MultiValuedIndex;
import com.google.gson.stream.JsonWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoryIndex
extends MultiValuedIndex<String, PageAnchor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CategoryIndex.class);

    public CategoryIndex() {
        super("Categories", CategoryIndex::getCategories, JsonWriter::value, (writer, value) -> writer.value(value.toString()));
    }

    private static List<Pair<String, PageAnchor>> getCategories(ParsedGuidePage page) {
        Object categoriesNode = page.getFrontmatter().additionalProperties().get("categories");
        if (categoriesNode == null) {
            return List.of();
        }
        if (!(categoriesNode instanceof List)) {
            LOGGER.warn("Page {} contains malformed categories frontmatter", (Object)page.getId());
            return List.of();
        }
        List categoryList = (List)categoriesNode;
        PageAnchor anchor = new PageAnchor(page.getId(), null);
        ArrayList<Pair<String, PageAnchor>> categories = new ArrayList<Pair<String, PageAnchor>>();
        for (Object listEntry : categoryList) {
            if (listEntry instanceof String) {
                String categoryString = (String)listEntry;
                categories.add((Pair<String, PageAnchor>)Pair.of((Object)categoryString, (Object)anchor));
                continue;
            }
            LOGGER.warn("Page {} contains a malformed categories frontmatter entry: {}", (Object)page.getId(), listEntry);
        }
        return categories;
    }
}

