/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.gui.component.custom;

import com.buuz135.industrial.api.conveyor.gui.PositionedGuiComponent;
import com.buuz135.industrial.gui.component.custom.ICanSendNetworkMessage;
import com.buuz135.industrial.proxy.block.filter.RegulatorFilter;
import com.hrznstudio.titanium.util.AssetUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public abstract class RegulatorFilterGuiComponent
extends PositionedGuiComponent {
    public static final ResourceLocation BG_TEXTURE = new ResourceLocation("industrialforegoing", "textures/gui/conveyor.png");

    public RegulatorFilterGuiComponent(int x, int y, int xSize, int ySize) {
        super(x, y, xSize, ySize);
    }

    @Override
    public boolean handleClick(AbstractContainerScreen conveyor, int guiX, int guiY, double mouseX, double mouseY) {
        int pos = 0;
        for (int i = 0; i < this.getYSize(); ++i) {
            for (int x = 0; x < this.getXSize(); ++x) {
                int posX = guiX + this.getXPos() + x * 18;
                int posY = guiY + this.getXPos() + i * 18;
                if (mouseX > (double)(posX + 1) && mouseX < (double)(posX + 1 + 16) && mouseY > (double)(posY + 1) && mouseY < (double)(posY + 1 + 16)) {
                    if (conveyor instanceof ICanSendNetworkMessage) {
                        ((ICanSendNetworkMessage)conveyor).sendMessage(pos, Minecraft.m_91087_().f_91074_.f_36096_.m_142621_().serializeNBT());
                    }
                    return true;
                }
                ++pos;
            }
        }
        return false;
    }

    @Override
    public boolean onScrolled(AbstractContainerScreen conveyor, int guiX, int guiY, double mouseX, double mouseY, double delta) {
        int pos = 0;
        for (int i = 0; i < this.getYSize(); ++i) {
            for (int x = 0; x < this.getXSize(); ++x) {
                int posX = guiX + this.getXPos() + x * 18;
                int posY = guiY + this.getXPos() + i * 18;
                if (mouseX > (double)(posX + 1) && mouseX < (double)(posX + 1 + 16) && mouseY > (double)(posY + 1) && mouseY < (double)(posY + 1 + 16)) {
                    if (conveyor instanceof ICanSendNetworkMessage) {
                        CompoundTag compoundNBT = new CompoundTag();
                        int amount = (int)delta;
                        if (Screen.m_96638_()) {
                            amount *= this.getFilter().getSmallMultiplier();
                        }
                        if (Screen.m_96637_()) {
                            amount *= this.getFilter().getBigMultiplier();
                        }
                        compoundNBT.m_128405_("Amount", amount);
                        ((ICanSendNetworkMessage)conveyor).sendMessage(pos, compoundNBT);
                    }
                    return true;
                }
                ++pos;
            }
        }
        return false;
    }

    @Override
    public void drawGuiBackgroundLayer(GuiGraphics guiGraphics, int guiX, int guiY, double mouseX, double mouseY) {
        int pos = 0;
        for (int i = 0; i < this.getYSize(); ++i) {
            for (int x = 0; x < this.getXSize(); ++x) {
                int posX = guiX + this.getXPos() + x * 18;
                int posY = guiY + this.getXPos() + i * 18;
                guiGraphics.m_280218_(BG_TEXTURE, posX, posY, 176, 0, 18, 18);
                if (!this.getFilter().getFilter()[pos].getStack().m_41619_()) {
                    guiGraphics.m_280480_(this.getFilter().getFilter()[pos].getStack(), posX + 1, posY + 1);
                    if (this.isRegulator()) {
                        guiGraphics.m_280168_().m_85836_();
                        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 260.0f);
                        guiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
                        String amount = "" + this.getFilter().getFilter()[pos].getAmount();
                        guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, ChatFormatting.WHITE + amount, (int)(((float)(posX + 17) - (float)Minecraft.m_91087_().f_91062_.m_92895_(amount) / 2.0f) * 2.0f), (posY + 13) * 2, 0xFFFFFF);
                        guiGraphics.m_280168_().m_85849_();
                    }
                }
                ++pos;
            }
        }
    }

    @Override
    public void drawGuiForegroundLayer(GuiGraphics guiGraphics, int guiX, int guiY, double mouseX, double mouseY) {
        for (int i = 0; i < this.getYSize(); ++i) {
            for (int x = 0; x < this.getXSize(); ++x) {
                int posX = guiX + this.getXPos() + x * 18;
                int posY = guiY + this.getXPos() + i * 18;
                if (!(mouseX > (double)(posX + 1)) || !(mouseX < (double)(posX + 1 + 16)) || !(mouseY > (double)(posY + 1)) || !(mouseY < (double)(posY + 1 + 16))) continue;
                AssetUtil.drawSelectingOverlay((GuiGraphics)guiGraphics, (int)(posX + 1 - guiX), (int)(posY + 1 - guiY), (int)(posX + 17 - guiX), (int)(posY + 17 - guiY));
                return;
            }
        }
    }

    @Override
    public boolean isInside(double mouseX, double mouseY) {
        return mouseX > (double)this.getXPos() && mouseX < (double)(this.getXPos() + this.getXSize() * 18) && mouseY > (double)this.getYPos() && mouseY < (double)(this.getYPos() + this.getYSize() * 18);
    }

    public abstract RegulatorFilter getFilter();

    public abstract boolean isRegulator();

    @Override
    @Nullable
    public List<Component> getTooltip(int guiX, int guiY, double mouseX, double mouseY) {
        int pos = 0;
        for (int i = 0; i < this.getYSize(); ++i) {
            for (int x = 0; x < this.getXSize(); ++x) {
                int posX = guiX + this.getXPos() + x * 18;
                int posY = guiY + this.getXPos() + i * 18;
                if (mouseX > (double)(posX + 1) && mouseX < (double)(posX + 1 + 16) && mouseY > (double)(posY + 1) && mouseY < (double)(posY + 1 + 16) && !this.getFilter().getFilter()[pos].getStack().m_41619_()) {
                    Screen cfr_ignored_0 = Minecraft.m_91087_().f_91080_;
                    List strings = Screen.m_280152_((Minecraft)Minecraft.m_91087_(), (ItemStack)this.getFilter().getFilter()[pos].getStack());
                    if (this.isRegulator()) {
                        strings.add(Component.m_237113_((String)(ChatFormatting.DARK_GRAY + "*Use Scroll Wheel to change*")));
                    }
                    return strings;
                }
                ++pos;
            }
        }
        return null;
    }
}

