/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.igleelib.common.baseutils;

import fr.iglee42.igleelib.common.blocks.entity.GhostBlockEntity;
import fr.iglee42.igleelib.common.client.ghostblock.GhostBlockModel;
import fr.iglee42.igleelib.common.client.ghostblock.GhostBlockRenderer;
import fr.iglee42.igleelib.common.init.ModBlock;
import fr.iglee42.igleelib.common.init.ModBlockEntities;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="igleelib", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEvents {
    public static final ResourceLocation GHOST_OVERLAY_LOCATION = new ResourceLocation("igleelib", "block/ghost_block_overlay");
    public static TextureAtlasSprite ghostOverlaySprite;

    @SubscribeEvent
    public static void clientStuff(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlock.GHOST_BLOCK.get()), (RenderType)RenderType.m_110466_());
    }

    @SubscribeEvent
    public static void onTextureStitched(TextureStitchEvent.Post event) {
        if (InventoryMenu.f_39692_.equals((Object)event.getAtlas().m_118330_())) {
            ghostOverlaySprite = event.getAtlas().m_118316_(GHOST_OVERLAY_LOCATION);
        }
    }

    @SubscribeEvent
    public static void onBlockColors(RegisterColorHandlersEvent.Block event) {
        BlockColors colors = event.getBlockColors();
        colors.m_92589_((state, world, pos, index) -> colors.m_92577_(((GhostBlockEntity)world.m_7702_(pos)).getStockedBlock(), world, pos, index), new Block[]{(Block)ModBlock.GHOST_BLOCK.get()});
    }

    @SubscribeEvent
    public static void onModelBaked(ModelEvent.ModifyBakingResult event) {
        Map registry = event.getModels();
        ClientEvents.put(registry, GhostBlockModel::new, (Block)ModBlock.GHOST_BLOCK.get());
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.GHOST_BLOCK.get(), GhostBlockRenderer::new);
    }

    private static void put(Map<ResourceLocation, BakedModel> registry, Function<BakedModel, BakedModel> creator, Block block) {
        for (BlockState state : block.m_49965_().m_61056_()) {
            registry.put((ResourceLocation)BlockModelShaper.m_110895_((BlockState)state), creator.apply(registry.get(BlockModelShaper.m_110895_((BlockState)state))));
        }
    }
}

