/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.igleelib.api.utils;

import fr.iglee42.igleelib.common.init.ModBlock;
import fr.iglee42.igleelib.common.init.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ModsUtils {
    public static String[] split(String base, String separator) {
        String[] st = base.split(separator);
        String[] finale = new String[st.length];
        int i = 0;
        String[] stringArray = st;
        int n = stringArray.length;
        for (int j = 0; j < n; ++j) {
            String s;
            String fi = s = stringArray[j];
            if (s.endsWith(separator)) {
                fi = s.substring(s.length() - 1);
            }
            finale[i] = fi;
            ++i;
        }
        return finale;
    }

    public static String getUpperName(String name, String wordSeparator) {
        String[] nm = ModsUtils.split(name, wordSeparator);
        StringBuilder end = new StringBuilder();
        int i = 0;
        for (String n : nm) {
            char fc = n.charAt(0);
            String fcs = String.valueOf(fc);
            String fs = fcs.toUpperCase() + n.substring(1);
            end.append(fs).append(++i == nm.length ? "" : " ");
        }
        return end.toString();
    }

    public static void placeGhostBlock(ServerLevel level, BlockPos pos, BlockState blockState, int dispearTime) {
        level.m_46597_(pos, ((Block)ModBlock.GHOST_BLOCK.get()).m_49966_());
        level.m_141902_(pos, (BlockEntityType)ModBlockEntities.GHOST_BLOCK.get()).ifPresent(g -> {
            g.setStockedBlock(blockState);
            g.setDispearTime(dispearTime);
        });
    }

    public static void saveStringToBuffer(FriendlyByteBuf buf, String s) {
        buf.writeInt(s.length());
        for (char c : s.toCharArray()) {
            buf.writeChar((int)c);
        }
    }

    public static String readStringFromBuffer(FriendlyByteBuf buf) {
        int length = buf.readInt();
        char[] word = new char[length];
        for (int i = 0; i < length; ++i) {
            word[i] = buf.readChar();
        }
        return String.valueOf(word);
    }

    public static <T extends ParticleOptions> void spawnParticle(T particleType, ServerLevel level, Vec3 fromPos, Vec3 goPos, int count) {
        if (level == null || level.m_5776_()) {
            return;
        }
        double x = fromPos.m_7096_();
        double y = fromPos.m_7098_();
        double z = fromPos.m_7094_();
        double velX = goPos.m_7096_() - fromPos.m_7096_();
        double velY = goPos.m_7098_() - fromPos.m_7098_();
        double velZ = goPos.m_7094_() - fromPos.m_7094_();
        level.m_8767_(particleType, x, y, z, count, velX, velY, velZ, 0.09);
    }

    public static void debugSign(Level level, BlockPos pos, String ... lines) {
        BlockEntity blockEntity = level.m_7702_(pos.m_122024_());
        if (blockEntity instanceof SignBlockEntity) {
            SignBlockEntity s = (SignBlockEntity)blockEntity;
            Component[] texts = new Component[4];
            for (int i = 0; i < lines.length && i <= 3; ++i) {
                texts[i] = Component.m_237113_((String)lines[i]);
            }
            s.m_276956_(new SignText(texts, new Component[]{CommonComponents.f_237098_, CommonComponents.f_237098_, CommonComponents.f_237098_, CommonComponents.f_237098_}, DyeColor.BLACK, false), true);
        }
    }
}

