/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrialforegoingsouls.block.tile;

import com.buuz135.industrialforegoingsouls.block.SoulSurgeBlock;
import com.buuz135.industrialforegoingsouls.block.tile.NetworkBlockEntity;
import com.buuz135.industrialforegoingsouls.block.tile.SoulLaserBaseBlockEntity;
import com.buuz135.industrialforegoingsouls.block_network.SoulNetwork;
import com.buuz135.industrialforegoingsouls.config.ConfigSoulSurge;
import com.buuz135.industrialforegoingsouls.tag.SoulTags;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.RotatableBlock;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.block_network.element.NetworkElement;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class SoulSurgeBlockEntity
extends NetworkBlockEntity<SoulSurgeBlockEntity> {
    @Save
    private int tickingTime;

    public SoulSurgeBlockEntity(BasicTileBlock<SoulSurgeBlockEntity> base, BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(base, blockEntityType, pos, state);
    }

    @NotNull
    public SoulSurgeBlockEntity getSelf() {
        return this;
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, SoulSurgeBlockEntity blockEntity) {
        super.serverTick(level, pos, state, (ActiveTile)blockEntity);
        if (((Boolean)state.m_61143_((Property)SoulSurgeBlock.ENABLED)).booleanValue()) {
            if (this.tickingTime <= 0) {
                SoulNetwork network = this.getNetwork();
                for (NetworkElement soulLaserDrill : network.getSoulLaserDrills()) {
                    SoulLaserBaseBlockEntity soulLaserBaseBlockEntity;
                    BlockEntity soulTile = soulLaserDrill.getLevel().m_7702_(soulLaserDrill.getPos());
                    if (!(soulTile instanceof SoulLaserBaseBlockEntity) || (soulLaserBaseBlockEntity = (SoulLaserBaseBlockEntity)soulTile).getSoulAmount() <= 0) continue;
                    soulLaserBaseBlockEntity.useSoul();
                    this.tickingTime = ConfigSoulSurge.SOUL_TIME;
                    break;
                }
            }
            if (this.tickingTime > 0) {
                BlockState targetingState = level.m_8055_(pos.m_121945_(((Direction)state.m_61143_((Property)RotatableBlock.FACING_ALL)).m_122424_()));
                if (!(targetingState.m_60713_(Blocks.f_50016_) || targetingState.m_204336_(SoulTags.Blocks.CANT_ACCELERATE) || targetingState.m_204336_(SoulTags.Blocks.FORGE_CANT_ACCELERATE))) {
                    BlockEntity targetingTile = level.m_7702_(pos.m_121945_(((Direction)state.m_61143_((Property)RotatableBlock.FACING_ALL)).m_122424_()));
                    if (targetingTile != null) {
                        BlockEntityTicker ticker = targetingState.m_155944_(this.f_58857_, targetingTile.m_58903_());
                        if (ticker != null) {
                            for (int i = 0; i < ConfigSoulSurge.ACCELERATION_TICK; ++i) {
                                ticker.m_155252_(level, pos.m_121945_(((Direction)state.m_61143_((Property)RotatableBlock.FACING_ALL)).m_122424_()), targetingState, targetingTile);
                            }
                            --this.tickingTime;
                        }
                    } else if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        if (serverLevel.f_46441_.m_188500_() < ConfigSoulSurge.RANDOM_TICK_ACCELERATION_CHANCE) {
                            for (int i = 0; i < ConfigSoulSurge.BLOCK_ACCELERATION_TICK; ++i) {
                                targetingState.m_222972_(serverLevel, pos.m_121945_(((Direction)state.m_61143_((Property)RotatableBlock.FACING_ALL)).m_122424_()), serverLevel.f_46441_);
                            }
                        }
                        --this.tickingTime;
                    }
                }
                if (targetingState.m_60713_(Blocks.f_50016_)) {
                    BlockPos posOffset = pos.m_121945_(((Direction)state.m_61143_((Property)RotatableBlock.FACING_ALL)).m_122424_());
                    VoxelShape box = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0).m_83216_((double)posOffset.m_123341_(), (double)posOffset.m_123342_(), (double)posOffset.m_123343_());
                    List entities = level.m_45976_(LivingEntity.class, box.m_83215_());
                    for (LivingEntity entity : entities) {
                        if (entity.m_6095_().m_204039_(SoulTags.Entities.CANT_ACCELERATE)) continue;
                        for (int i = 0; i < ConfigSoulSurge.ENTITIES_ACCELERATION_TICK; ++i) {
                            entity.m_8119_();
                        }
                        --this.tickingTime;
                    }
                }
            }
        }
    }
}

