/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.parsers;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Element {
    @Nonnull
    public final Type type;
    @Nullable
    public final String comment;
    @Nullable
    public final String name;
    @Nullable
    public final Object value;
    @Nullable
    public final Element[] subArray;

    public Element(@Nonnull Type type, @Nullable String comment, @Nullable String name, @Nonnull Object value) {
        this.type = type;
        this.comment = comment;
        this.name = name;
        this.value = value;
        this.subArray = null;
    }

    public Element(@Nonnull Type type, @Nullable String comment, @Nullable String name, @Nonnull Element[] value) {
        this.type = type;
        this.comment = comment;
        this.name = name;
        this.value = null;
        this.subArray = value;
    }

    public String asString() {
        assert (this.value != null);
        return this.value.toString();
    }

    public boolean asBool() {
        assert (this.value != null);
        return (Boolean)this.value;
    }

    public long asLong() {
        assert (this.value != null);
        return ((Number)this.value).longValue();
    }

    public double asDouble() {
        assert (this.value != null);
        return ((Number)this.value).doubleValue();
    }

    public static enum Type {
        String,
        Number,
        Boolean,
        Array,
        Map;

    }
}

