/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.multiblock;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.roguelogix.phosphophyllite.multiblock.MultiblockController;
import net.roguelogix.phosphophyllite.multiblock.validated.IValidatedMultiblock;
import net.roguelogix.phosphophyllite.registry.OnModLoad;
import net.roguelogix.phosphophyllite.util.Util;

public final class MultiblockRegistry {
    private static final Object2ObjectOpenHashMap<ServerLevel, ObjectArrayList<MultiblockController<?, ?, ?>>> controllersToTick = new Object2ObjectOpenHashMap();
    private static final ObjectArrayList<MultiblockController<?, ?, ?>> newControllers = new ObjectArrayList();
    private static final ObjectArrayList<MultiblockController<?, ?, ?>> oldControllers = new ObjectArrayList();

    public static void addController(MultiblockController<?, ?, ?> controller) {
        newControllers.add(controller);
    }

    public static void removeController(MultiblockController<?, ?, ?> controller) {
        oldControllers.add(controller);
    }

    @OnModLoad
    private static void onModLoad() {
        MinecraftForge.EVENT_BUS.register(MultiblockRegistry.class);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    static void onWorldUnload(LevelEvent.Unload worldUnloadEvent) {
        if (!worldUnloadEvent.getLevel().m_5776_()) {
            ObjectArrayList controllersToTick = (ObjectArrayList)MultiblockRegistry.controllersToTick.remove((Object)worldUnloadEvent.getLevel());
            if (controllersToTick != null) {
                for (MultiblockController multiblockController2 : controllersToTick) {
                    multiblockController2.suicide();
                }
            }
            newControllers.removeIf(multiblockController -> multiblockController.level == worldUnloadEvent.getLevel());
            oldControllers.removeIf(multiblockController -> multiblockController.level == worldUnloadEvent.getLevel());
        }
    }

    @SubscribeEvent
    static void onServerStop(ServerStoppedEvent serverStoppedEvent) {
        controllersToTick.clear();
        newControllers.clear();
        oldControllers.clear();
    }

    @SubscribeEvent
    static void tickServer(TickEvent.ServerTickEvent e) {
        for (MultiblockController newController : newControllers) {
            ((ObjectArrayList)controllersToTick.computeIfAbsent((Object)((ServerLevel)newController.level), k -> new ObjectArrayList())).add((Object)newController);
        }
        newControllers.clear();
        for (MultiblockController oldController : oldControllers) {
            ObjectArrayList controllers = (ObjectArrayList)controllersToTick.get((Object)oldController.level);
            controllers.remove((Object)oldController);
        }
        oldControllers.clear();
    }

    @SubscribeEvent
    static void tickWorld(TickEvent.LevelTickEvent e) {
        if (!(e.level instanceof ServerLevel)) {
            return;
        }
        Util.updateBlockStates(e.level);
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        ObjectArrayList controllersToTick = (ObjectArrayList)MultiblockRegistry.controllersToTick.get((Object)e.level);
        if (controllersToTick != null) {
            for (MultiblockController controller : controllersToTick) {
                if (controller == null) continue;
                controller.update();
            }
        }
    }

    public static void revalidateAll() {
        controllersToTick.forEach((serverLevel, multiblockControllers) -> multiblockControllers.forEach(controller -> {
            if (controller instanceof IValidatedMultiblock) {
                IValidatedMultiblock validatedMultiblock = (IValidatedMultiblock)((Object)controller);
                validatedMultiblock.requestValidation();
            }
        }));
    }
}

