/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.config.spec;

import java.lang.reflect.Field;
import net.roguelogix.phosphophyllite.config.ConfigValue;
import net.roguelogix.phosphophyllite.config.spec.ConfigOptionsDefaults;
import net.roguelogix.phosphophyllite.config.spec.DefinitionError;
import net.roguelogix.phosphophyllite.config.spec.SpecObjectNode;
import net.roguelogix.phosphophyllite.config.spec.SpecValueNode;
import net.roguelogix.phosphophyllite.util.NonnullDefault;

@NonnullDefault
public abstract class SpecNumberNode
extends SpecValueNode {
    public final boolean lowerInclusive;
    public final boolean upperInclusive;

    protected SpecNumberNode(SpecObjectNode parent, Field field, ConfigOptionsDefaults defaults) {
        super(parent, field, defaults);
        ConfigValue annotation = field.getAnnotation(ConfigValue.class);
        String range = annotation.range();
        range = range.trim();
        if (range.length() < 3) {
            throw new DefinitionError("Incomplete range given");
        }
        char lowerInclusiveChar = range.charAt(0);
        char upperInclusiveChar = range.charAt(range.length() - 1);
        this.lowerInclusive = switch (lowerInclusiveChar) {
            case '(' -> false;
            case '[' -> true;
            default -> throw new DefinitionError("Unknown lower bound inclusivity");
        };
        this.upperInclusive = switch (upperInclusiveChar) {
            case ')' -> false;
            case ']' -> true;
            default -> throw new DefinitionError("Unknown higher bound inclusivity");
        };
    }

    public abstract String lowerBoundAsString();

    public abstract String upperBoundAsString();
}

