/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.blazing.logic;

import java.util.function.Function;
import mcjty.rftoolspower.modules.blazing.items.IBlazingRod;

public class BlazingAgitatorAlgorithm {
    private final Function<Integer, IBlazingRod> items;

    public BlazingAgitatorAlgorithm(Function<Integer, IBlazingRod> items) {
        this.items = items;
    }

    private float calculateQualityFactor(int i) {
        IBlazingRod stack = this.items.apply(i);
        if (stack.isValid()) {
            float duration = stack.getPowerDuration() * 20.0f / 10000.0f;
            float quality = stack.getPowerQuality() * 60000.0f / 1.5E8f;
            return Math.min((duration + quality) / 2.0f, 40.0f);
        }
        return 0.0f;
    }

    private float calculateQualityFactorDiff(float fThis, int i, int x, int y) {
        if (x < 0 || y < 0 || x > 2 || y > 2) {
            return -0.03f;
        }
        IBlazingRod stack = this.items.apply(i);
        if (!stack.isValid()) {
            return -0.03f;
        }
        float max = this.calculateQualityFactor(i) - fThis;
        return Math.max(-0.03f, max);
    }

    private float calculateAdjacencyFactor(int i) {
        float fThis = this.calculateQualityFactor(i);
        int x = i % 3;
        int y = i / 3;
        float factor = 1.0f;
        factor += this.calculateQualityFactorDiff(fThis, i - 1, x - 1, y);
        factor += this.calculateQualityFactorDiff(fThis, i + 1, x + 1, y);
        factor += this.calculateQualityFactorDiff(fThis, i - 3, x, y - 1);
        if ((factor += this.calculateQualityFactorDiff(fThis, i + 3, x, y + 1)) < 0.01f) {
            factor = 0.01f;
        }
        return factor / 4.0f;
    }

    public void tickBlazingRod(int i, IBlazingRod stack, float timeLeft, float infuseFactor) {
        float adjacencyFactor = this.calculateAdjacencyFactor(i);
        stack.setAgitationTimeLeft(timeLeft -= adjacencyFactor / 5.0f);
        float powerQuality = stack.getPowerQuality();
        stack.setPowerQuality(powerQuality += adjacencyFactor * adjacencyFactor * 10.0f * (1.0f + infuseFactor / 10.0f));
        float powerDuration = stack.getPowerDuration();
        stack.setPowerDuration(powerDuration += adjacencyFactor * adjacencyFactor * (1.0f + infuseFactor / 10.0f));
    }
}

