/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.fluids.FluidStack;
import net.yxiao233.ifeu.common.config.machine.FluidCraftingTableConfig;
import net.yxiao233.ifeu.common.registry.ModRenderTypes;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Matrix4f;

public class RendererHelper {
    private static final Function<ResourceLocation, TextureAtlasSprite> TEXTURE_GETTER = location -> (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(location);

    public static Triple<Float, Float, Float> intToRGB(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        return Triple.of((Object)Float.valueOf(red), (Object)Float.valueOf(green), (Object)Float.valueOf(blue));
    }

    public static void renderFluidContext(FluidStack fluid, PoseStack matrixStack, IFluidContextRender render) {
        if (fluid != null && fluid.getAmount() > 0) {
            matrixStack.m_85836_();
            RenderSystem.enableBlend();
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            Minecraft.m_91087_().m_91097_().m_174784_(TextureAtlas.f_118259_);
            render.render();
            RenderSystem.disableBlend();
            matrixStack.m_85849_();
        }
    }

    public static TextureAtlasSprite getFluidIcon(Fluid fluid, Direction side) {
        return RendererHelper.getFluidIcon(new FluidStack(fluid, 1000), side);
    }

    public static TextureAtlasSprite getFluidIcon(FluidStack fluid, Direction side) {
        IClientFluidTypeExtensions renderProperties;
        TextureAtlasSprite icon;
        if (side == null) {
            side = Direction.UP;
        }
        if ((icon = TEXTURE_GETTER.apply((renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid())).getFlowingTexture(fluid))) == null || side == Direction.UP || side == Direction.DOWN) {
            icon = TEXTURE_GETTER.apply(renderProperties.getStillTexture(fluid));
        }
        return icon;
    }

    public static void renderFullFluid(PoseStack poseStack, MultiBufferSource multiBufferSource, BlockEntity entity, FluidStack fluidStack, int combinedLight) {
        RendererHelper.renderFluidContext(fluidStack, poseStack, () -> {
            float height = (float)fluidStack.getAmount() * 1.0f / (float)FluidCraftingTableConfig.maxInputTankSize;
            height = Math.min(height, 0.995f);
            int brightness = Math.max(combinedLight, fluidStack.getFluid().getFluidType().getLightLevel(fluidStack));
            int l2 = brightness >> 16 & 0xFFFF;
            int i3 = brightness & 0xFFFF;
            TextureAtlasSprite icon = RendererHelper.getFluidIcon(fluidStack, Direction.UP);
            IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
            Triple<Float, Float, Float> color = RendererHelper.intToRGB(renderProperties.getTintColor(fluidStack.getFluid().m_76145_(), (BlockAndTintGetter)entity.m_58904_(), entity.m_58899_()));
            VertexConsumer vb = multiBufferSource.m_6299_(RenderType.m_110497_((ResourceLocation)icon.m_247685_()));
            Matrix4f matrix = poseStack.m_85850_().m_252922_();
            vb.m_252986_(matrix, 0.005f, height, 0.005f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118409_(), icon.m_118412_()).m_7120_(l2, i3).m_5752_();
            vb.m_252986_(matrix, 0.005f, height, 0.995f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118409_(), icon.m_118411_()).m_7120_(l2, i3).m_5752_();
            vb.m_252986_(matrix, 0.995f, height, 0.995f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118410_(), icon.m_118411_()).m_7120_(l2, i3).m_5752_();
            vb.m_252986_(matrix, 0.995f, height, 0.005f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118410_(), icon.m_118412_()).m_7120_(l2, i3).m_5752_();
            vb.m_252986_(matrix, 0.005f, 0.005f, 0.005f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118409_(), icon.m_118412_()).m_7120_(l2, i3).m_5752_();
            vb.m_252986_(matrix, 0.995f, 0.005f, 0.005f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118409_(), icon.m_118411_()).m_7120_(l2, i3).m_5752_();
            vb.m_252986_(matrix, 0.995f, 0.005f, 0.995f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118410_(), icon.m_118411_()).m_7120_(l2, i3).m_5752_();
            vb.m_252986_(matrix, 0.005f, 0.005f, 0.995f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118410_(), icon.m_118412_()).m_7120_(l2, i3).m_5752_();
            vb.m_252986_(matrix, 0.005f, 0.005f, 0.995f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118409_(), icon.m_118412_()).m_7120_(l2, i3).m_5752_();
            vb.m_252986_(matrix, 0.995f, 0.005f, 0.995f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118410_(), icon.m_118412_()).m_7120_(l2, i3).m_5752_();
            vb.m_252986_(matrix, 0.995f, height, 0.995f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118410_(), icon.m_118411_()).m_7120_(l2, i3).m_5752_();
            vb.m_252986_(matrix, 0.005f, height, 0.995f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118409_(), icon.m_118411_()).m_7120_(l2, i3).m_5752_();
            vb.m_252986_(matrix, 0.005f, 0.005f, 0.005f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118409_(), icon.m_118411_()).m_7120_(l2, i3).m_5752_();
            vb.m_252986_(matrix, 0.005f, height, 0.005f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118409_(), icon.m_118412_()).m_7120_(l2, i3).m_5752_();
            vb.m_252986_(matrix, 0.995f, height, 0.005f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118410_(), icon.m_118412_()).m_7120_(l2, i3).m_5752_();
            vb.m_252986_(matrix, 0.995f, 0.005f, 0.005f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118410_(), icon.m_118411_()).m_7120_(l2, i3).m_5752_();
            vb.m_252986_(matrix, 0.995f, 0.005f, 0.005f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118409_(), icon.m_118411_()).m_7120_(l2, i3).m_5752_();
            vb.m_252986_(matrix, 0.995f, height, 0.005f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118409_(), icon.m_118412_()).m_7120_(l2, i3).m_5752_();
            vb.m_252986_(matrix, 0.995f, height, 0.995f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118410_(), icon.m_118412_()).m_7120_(l2, i3).m_5752_();
            vb.m_252986_(matrix, 0.995f, 0.005f, 0.995f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118410_(), icon.m_118411_()).m_7120_(l2, i3).m_5752_();
            vb.m_252986_(matrix, 0.005f, 0.005f, 0.995f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118409_(), icon.m_118411_()).m_7120_(l2, i3).m_5752_();
            vb.m_252986_(matrix, 0.005f, height, 0.995f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118409_(), icon.m_118412_()).m_7120_(l2, i3).m_5752_();
            vb.m_252986_(matrix, 0.005f, height, 0.005f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118410_(), icon.m_118412_()).m_7120_(l2, i3).m_5752_();
            vb.m_252986_(matrix, 0.005f, 0.005f, 0.005f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118410_(), icon.m_118411_()).m_7120_(l2, i3).m_5752_();
        });
    }

    public static void renderGhostBlockContext(BlockPos entityBlockPos, PoseStack poseStack, IBlockContextRender render) {
        poseStack.m_85836_();
        poseStack.m_252880_((float)(-entityBlockPos.m_123341_()), (float)(-entityBlockPos.m_123342_()), (float)(-entityBlockPos.m_123343_()));
        render.render();
        poseStack.m_85849_();
    }

    public static void renderSingleGhostBlock(PoseStack poseStack, MultiBufferSource multiBufferSource, BlockPos entityBlockPos, BlockPos renderBlockPos, BlockState blockState) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        VertexConsumer consumer = multiBufferSource.m_6299_(ModRenderTypes.GHOST);
        if (level == null) {
            return;
        }
        RendererHelper.renderGhostBlockContext(entityBlockPos, poseStack, () -> RendererHelper.lambda$renderSingleGhostBlock$2(poseStack, renderBlockPos, minecraft, blockState, (Level)level, consumer));
    }

    private static /* synthetic */ void lambda$renderSingleGhostBlock$2(PoseStack poseStack, BlockPos renderBlockPos, Minecraft minecraft, BlockState blockState, Level level, VertexConsumer consumer) {
        poseStack.m_85836_();
        poseStack.m_252880_((float)renderBlockPos.m_123341_(), (float)renderBlockPos.m_123342_(), (float)renderBlockPos.m_123343_());
        minecraft.m_91289_().renderBatched(blockState, renderBlockPos, (BlockAndTintGetter)level, poseStack, consumer, false, level.m_213780_(), ModelData.EMPTY, null);
        poseStack.m_85849_();
    }

    public static interface IFluidContextRender {
        public void render();
    }

    public static interface IBlockContextRender {
        public void render();
    }
}

