/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.networking.packet;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.yxiao233.ifeu.api.networking.BooleanValueSyncS2C;

public class BooleanSyncS2CPacket {
    private final boolean[] value;
    private final BlockPos blockPos;
    private final int size;

    public BooleanSyncS2CPacket(BlockPos blockPos, boolean ... value) {
        this.value = value;
        this.blockPos = blockPos;
        this.size = value.length;
    }

    public BooleanSyncS2CPacket(BlockPos blockPos, boolean value) {
        this.value = new boolean[]{value};
        this.blockPos = blockPos;
        this.size = this.value.length;
    }

    public BooleanSyncS2CPacket(FriendlyByteBuf buffer) {
        this.size = buffer.readInt();
        this.blockPos = buffer.m_130135_();
        boolean[] temp = new boolean[this.size];
        for (int i = 0; i < this.size; ++i) {
            temp[i] = buffer.readBoolean();
        }
        this.value = temp;
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.writeInt(this.size);
        buffer.m_130064_(this.blockPos);
        for (boolean b : this.value) {
            buffer.writeBoolean(b);
        }
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(this.blockPos);
            if (blockEntity instanceof BooleanValueSyncS2C) {
                BooleanValueSyncS2C entity = (BooleanValueSyncS2C)blockEntity;
                entity.setValue(this.value);
                blockEntity.m_6596_();
            }
        });
        return true;
    }
}

