/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.compact.kubejs.components;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.fluid.FluidStack;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.fluid.InputFluid;
import dev.latvian.mods.kubejs.fluid.OutputFluid;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.ComponentRole;
import dev.latvian.mods.kubejs.recipe.component.NumberComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentBuilder;
import dev.latvian.mods.kubejs.util.MapJS;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class IndustrialForegoingComponents {
    public static RecipeComponent<InputFluid> INPUT_FLUID = new RecipeComponent<InputFluid>(){

        public String componentType() {
            return "input_fluid";
        }

        public ComponentRole role() {
            return ComponentRole.INPUT;
        }

        public Class<?> componentClass() {
            return InputFluid.class;
        }

        public JsonElement write(RecipeJS recipeJS, InputFluid inputFluid) {
            FluidStackJS stack = (FluidStackJS)inputFluid;
            return stack.kjs$isEmpty() ? null : new JsonPrimitive(stack.getFluidStack().write(new CompoundTag()).toString());
        }

        private InputFluid readString(RecipeJS recipe, String string) {
            try {
                return recipe.readInputFluid((Object)FluidStack.read((CompoundTag)TagParser.m_129359_((String)string)));
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        public InputFluid read(RecipeJS recipeJS, Object o) {
            JsonPrimitive primitive;
            if (o instanceof JsonPrimitive && (primitive = (JsonPrimitive)o).isString()) {
                return this.readString(recipeJS, primitive.getAsString());
            }
            return recipeJS.readInputFluid(o);
        }

        public boolean hasPriority(RecipeJS recipe, Object from) {
            return recipe.inputFluidHasPriority(from);
        }

        public String checkEmpty(RecipeKey<InputFluid> key, InputFluid value) {
            if (value.kjs$isEmpty()) {
                return "Input fluid '" + key.name + "' can't be empty!";
            }
            return "";
        }

        public String toString() {
            return this.componentType();
        }
    };
    public static RecipeComponent<OutputFluid> OUTPUT_FLUID = new RecipeComponent<OutputFluid>(){

        public String componentType() {
            return "output_fluid";
        }

        public ComponentRole role() {
            return ComponentRole.OUTPUT;
        }

        public Class<?> componentClass() {
            return OutputFluid.class;
        }

        public JsonElement write(RecipeJS recipe, OutputFluid value) {
            FluidStackJS stack = (FluidStackJS)value;
            return stack.kjs$isEmpty() ? null : new JsonPrimitive(stack.getFluidStack().write(new CompoundTag()).toString());
        }

        private OutputFluid readString(RecipeJS recipe, String str) {
            try {
                return recipe.readOutputFluid((Object)FluidStack.read((CompoundTag)TagParser.m_129359_((String)str)));
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        public OutputFluid read(RecipeJS recipe, Object from) {
            JsonPrimitive prim;
            if (from instanceof JsonPrimitive && (prim = (JsonPrimitive)from).isString()) {
                return this.readString(recipe, prim.getAsString());
            }
            return recipe.readOutputFluid(from);
        }

        public boolean hasPriority(RecipeJS recipe, Object from) {
            return recipe.outputFluidHasPriority(from);
        }

        public String checkEmpty(RecipeKey<OutputFluid> key, OutputFluid value) {
            if (value.kjs$isEmpty()) {
                return "Output fluid '" + key.name + "' can't be empty!";
            }
            return "";
        }

        public String toString() {
            return this.componentType();
        }
    };
    public static RecipeComponent<ResourceKey[]> RESOURCE_KEY = new RecipeComponent<ResourceKey[]>(){

        public String componentType() {
            return "resource_key";
        }

        public Class<?> componentClass() {
            return ResourceKey[].class;
        }

        public JsonElement write(RecipeJS recipe, ResourceKey[] keys) {
            JsonObject json = new JsonObject();
            if (keys.length > 0) {
                json.addProperty("type", keys[0].m_211136_().toString());
                JsonArray array = new JsonArray();
                for (ResourceKey registryKey : keys) {
                    array.add(registryKey.m_135782_().toString());
                }
                json.add("values", (JsonElement)array);
            }
            return json;
        }

        public ResourceKey[] read(RecipeJS recipe, Object from) {
            JsonObject element = MapJS.json((Object)from);
            if (element == null) {
                return null;
            }
            ResourceKey[] registryKeys = new ResourceKey[]{};
            if (element.getAsJsonObject().has("type")) {
                JsonArray values = element.getAsJsonObject().getAsJsonArray("values");
                registryKeys = new ResourceKey[values.size()];
                int i = 0;
                for (JsonElement jsonElement : values) {
                    registryKeys[i] = ResourceKey.m_135785_((ResourceKey)ResourceKey.m_135788_((ResourceLocation)new ResourceLocation(element.getAsJsonObject().get("type").getAsString())), (ResourceLocation)new ResourceLocation(jsonElement.getAsString()));
                    ++i;
                }
            }
            return registryKeys;
        }
    };
    public static RecipeComponentBuilder RARITY = new RecipeComponentBuilder(5).add(RESOURCE_KEY.key("whitelist")).add(RESOURCE_KEY.key("blacklist")).add(NumberComponent.INT.key("depth_min")).add(NumberComponent.INT.key("depth_max")).add(NumberComponent.INT.key("weight"));
}

