/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.compact.jei;

import com.buuz135.industrial.plugin.jei.IndustrialRecipeTypes;
import com.hrznstudio.titanium.container.BasicAddonContainer;
import com.hrznstudio.titanium.util.RecipeUtil;
import java.util.ArrayList;
import java.util.Collections;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.yxiao233.ifeu.common.compact.jei.ModRecipeType;
import net.yxiao233.ifeu.common.compact.jei.category.ArcaneDragonEggForgingCategory;
import net.yxiao233.ifeu.common.compact.jei.category.BlockRightClickCategory;
import net.yxiao233.ifeu.common.compact.jei.category.DragonGeneratorCategory;
import net.yxiao233.ifeu.common.compact.jei.category.DragonStarGeneratorCategory;
import net.yxiao233.ifeu.common.compact.jei.category.InfuserCategory;
import net.yxiao233.ifeu.common.compact.jei.category.ShapedCategory;
import net.yxiao233.ifeu.common.compact.jei.category.ShapelessCategory;
import net.yxiao233.ifeu.common.config.machine.DragonGeneratorConfig;
import net.yxiao233.ifeu.common.config.machine.DragonStarGeneratorConfig;
import net.yxiao233.ifeu.common.recipe.BlockRightClickRecipe;
import net.yxiao233.ifeu.common.recipe.DragonGeneratorRecipe;
import net.yxiao233.ifeu.common.recipe.DragonStarGeneratorRecipe;
import net.yxiao233.ifeu.common.recipe.InfuserRecipe;
import net.yxiao233.ifeu.common.registry.ModBlocks;
import net.yxiao233.ifeu.common.registry.ModContents;
import net.yxiao233.ifeu.common.registry.ModFluids;
import net.yxiao233.ifeu.common.registry.ModRecipes;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("ifeu", "jei_plugin");
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        jeiRuntime.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singletonList(new ItemStack((ItemLike)ModContents.AIR.get())));
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new InfuserCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ArcaneDragonEggForgingCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BlockRightClickCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new DragonStarGeneratorCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ShapedCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ShapelessCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new DragonGeneratorCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.addInfuserCompactRecipes(registration);
        this.addBlockRightClickRecipes(registration);
        this.addDragonStarGeneratorRecipe(registration);
        this.addDragonGeneratorRecipe(registration);
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        registration.addRecipes(ModRecipeType.INFUSER, RecipeUtil.getRecipes((Level)level, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ModRecipes.INFUSER_TYPE.get())));
        registration.addRecipes(ModRecipeType.ARCANE_DRAGON_EGG_FORGING, RecipeUtil.getRecipes((Level)level, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ModRecipes.ARCANE_DRAGON_EGG_FORGING_TYPE.get())));
        registration.addRecipes(ModRecipeType.BLOCK_RIGHT_CLICK, RecipeUtil.getRecipes((Level)level, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ModRecipes.BLOCK_RIGHT_CLICK_TYPE.get())));
        registration.addRecipes(ModRecipeType.DRAGON_STAR_GENERATOR, RecipeUtil.getRecipes((Level)level, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ModRecipes.DRAGON_STAR_GENERATOR_TYPE.get())));
        registration.addRecipes(ModRecipeType.SHAPED, RecipeUtil.getRecipes((Level)level, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ModRecipes.SHAPED_TYPE.get())));
        registration.addRecipes(ModRecipeType.SHAPELESS, RecipeUtil.getRecipes((Level)level, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ModRecipes.SHAPELESS_TYPE.get())));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(((Block)((RegistryObject)ModBlocks.INFUSER.getLeft()).get()).m_5456_().m_7968_(), new RecipeType[]{ModRecipeType.INFUSER});
        registration.addRecipeCatalyst(((Block)((RegistryObject)ModBlocks.ARCANE_DRAGON_EGG_FORGING.getLeft()).get()).m_5456_().m_7968_(), new RecipeType[]{ModRecipeType.ARCANE_DRAGON_EGG_FORGING});
        registration.addRecipeCatalyst(Blocks.f_50260_.m_5456_().m_7968_(), new RecipeType[]{ModRecipeType.BLOCK_RIGHT_CLICK});
        registration.addRecipeCatalyst(((Block)((RegistryObject)ModBlocks.DRAGON_STAR_GENERATOR.getLeft()).get()).m_5456_().m_7968_(), new RecipeType[]{ModRecipeType.DRAGON_STAR_GENERATOR});
        registration.addRecipeCatalyst(((Block)((RegistryObject)ModBlocks.FLUID_CRAFTING_TABLE.getLeft()).get()).m_5456_().m_7968_(), new RecipeType[]{ModRecipeType.SHAPED});
        registration.addRecipeCatalyst(((Block)((RegistryObject)ModBlocks.FLUID_CRAFTING_TABLE.getLeft()).get()).m_5456_().m_7968_(), new RecipeType[]{ModRecipeType.SHAPELESS});
        registration.addRecipeCatalyst(((Block)((RegistryObject)ModBlocks.DRAGON_GENERATOR.getLeft()).get()).m_5456_().m_7968_(), new RecipeType[]{ModRecipeType.DRAGON_GENERATOR});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(BasicAddonContainer.class, null, ModRecipeType.SHAPED, 4, 9, 16, 36);
        registration.addRecipeTransferHandler(BasicAddonContainer.class, null, ModRecipeType.SHAPELESS, 4, 9, 16, 36);
        registration.addRecipeTransferHandler(BasicAddonContainer.class, null, IndustrialRecipeTypes.DISSOLUTION, 4, 8, 17, 36);
    }

    private void addInfuserCompactRecipes(IRecipeRegistration registration) {
        ArrayList infuserRecipes = new ArrayList();
        ForgeRegistries.ITEMS.getEntries().forEach(reg -> {
            BucketItem bucketItem;
            FluidStack fluidStack;
            if (reg.getValue() instanceof MobBucketItem || ((Item)reg.getValue()).m_7968_().m_150930_(Items.f_42446_)) {
                return;
            }
            Object patt6100$temp = reg.getValue();
            if (patt6100$temp instanceof BucketItem && !(fluidStack = new FluidStack((bucketItem = (BucketItem)patt6100$temp).getFluid(), 1000)).isEmpty()) {
                String raw = bucketItem.m_5524_();
                int firstPoint = raw.indexOf(46);
                int lastPoint = raw.lastIndexOf(46);
                String nameSpace = raw.substring(firstPoint + 1, lastPoint);
                String path = raw.substring(lastPoint + 1, raw.length());
                ResourceLocation resourceLocation = new ResourceLocation("ifeu", "infuser/" + nameSpace + "/fill_" + path);
                infuserRecipes.add(new InfuserRecipe(resourceLocation, Items.f_42446_.m_7968_(), fluidStack, 200, bucketItem.m_7968_()));
            }
        });
        registration.addRecipes(ModRecipeType.INFUSER, infuserRecipes);
    }

    private void addBlockRightClickRecipes(IRecipeRegistration registration) {
        ArrayList<BlockRightClickRecipe> blockRightClickRecipes = new ArrayList<BlockRightClickRecipe>();
        blockRightClickRecipes.add(new BlockRightClickRecipe(new ResourceLocation("ifeu", "block_right_click"), (Block)ModContents.DEAD_DRAGON_EGG.get(), ((Item)ModContents.DRAGON_STAR.get()).m_7968_(), Blocks.f_50260_));
        registration.addRecipes(ModRecipeType.BLOCK_RIGHT_CLICK, blockRightClickRecipes);
    }

    private void addDragonStarGeneratorRecipe(IRecipeRegistration registration) {
        ArrayList<DragonStarGeneratorRecipe> dragonStarGeneratorCategories = new ArrayList<DragonStarGeneratorRecipe>();
        dragonStarGeneratorCategories.add(new DragonStarGeneratorRecipe(new ResourceLocation("ifeu", "dragon_star"), ((Item)ModContents.DRAGON_STAR.get()).m_7968_(), DragonStarGeneratorConfig.maxProgress, DragonStarGeneratorConfig.powerPerTick));
        registration.addRecipes(ModRecipeType.DRAGON_STAR_GENERATOR, dragonStarGeneratorCategories);
    }

    private void addDragonGeneratorRecipe(IRecipeRegistration registration) {
        ArrayList<DragonGeneratorRecipe> dragonGeneratorRecipes = new ArrayList<DragonGeneratorRecipe>();
        dragonGeneratorRecipes.add(new DragonGeneratorRecipe(new ResourceLocation("ifeu", "liquid_dragon_breath"), new FluidStack((Fluid)ModFluids.LIQUID_DRAGON_BREATH.getSourceFluid().get(), 1000), DragonGeneratorConfig.maxProgress, DragonGeneratorConfig.powerPerTick));
        registration.addRecipes(ModRecipeType.DRAGON_GENERATOR, dragonGeneratorRecipes);
    }
}

