/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.block.entity;

import com.buuz135.industrial.block.tile.IndustrialProcessingTile;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAssetType;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.client.screen.addon.ProgressBarScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonInfo;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.button.ArrowButtonComponent;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.util.FacingUtil;
import com.hrznstudio.titanium.util.LangUtil;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.yxiao233.ifeu.api.components.CustomTooltipComponent;
import net.yxiao233.ifeu.api.components.TextGuiComponent;
import net.yxiao233.ifeu.api.components.TextureGuiComponent;
import net.yxiao233.ifeu.api.networking.BooleanValueSyncS2C;
import net.yxiao233.ifeu.common.config.machine.TimeControllerConfig;
import net.yxiao233.ifeu.common.gui.AllGuiTextures;
import net.yxiao233.ifeu.common.networking.ModNetWorking;
import net.yxiao233.ifeu.common.networking.packet.BooleanSyncS2CPacket;
import net.yxiao233.ifeu.common.networking.packet.TimeControllerEntityKeyDownSyncC2SPacket;
import net.yxiao233.ifeu.common.registry.ModBlocks;
import net.yxiao233.ifeu.common.registry.ModContents;
import net.yxiao233.ifeu.common.utils.KeyDownUtil;
import net.yxiao233.ifeu.common.utils.TimeGetter;
import org.jetbrains.annotations.NotNull;

public class TimeControllerEntity
extends IndustrialProcessingTile<TimeControllerEntity>
implements BooleanValueSyncS2C {
    public static TimeGetter[] times = new TimeGetter[]{TimeGetter.DAY, TimeGetter.NOON, TimeGetter.NIGHT, TimeGetter.MIDNIGHT, TimeGetter.T, TimeGetter.S, TimeGetter.D};
    private int powerPerTick;
    @Save
    private SidedInventoryComponent<TimeControllerEntity> input = (SidedInventoryComponent)new SidedInventoryComponent("dragon_star_input", 33, 40, 1, 0).setColor(DyeColor.PURPLE).setInputFilter((stack, integer) -> stack.m_150930_((Item)ModContents.DRAGON_STAR.get())).setOutputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
    @Save
    private ProgressBarComponent<TimeControllerEntity> bar;
    @Save
    public long time;
    @Save
    public int choose;
    @Save
    public boolean hasButtonTip = false;
    private boolean finish = false;
    public static boolean isShiftDown;
    public static boolean isCtrlDown;

    public TimeControllerEntity(BlockPos blockPos, BlockState blockState) {
        super(ModBlocks.TIME_CONTROLLER, 66, 40, blockPos, blockState);
        this.addInventory((InventoryComponent)this.input);
        this.bar = new ProgressBarComponent<TimeControllerEntity>(53, 20, 10){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new ProgressBarScreenAddon<TimeControllerEntity>(TimeControllerEntity.this.bar.getPosX(), TimeControllerEntity.this.bar.getPosY(), (ProgressBarComponent)this){

                    public List<Component> getTooltipLines() {
                        Component[] var10000 = new Component[1];
                        ChatFormatting var10003 = ChatFormatting.GOLD;
                        var10000[0] = Component.m_237113_((String)(var10003 + "Amount: " + ChatFormatting.WHITE + NumberFormat.getNumberInstance(Locale.ROOT).format(TimeControllerEntity.this.bar.getProgress()) + ChatFormatting.GOLD + "/" + ChatFormatting.WHITE + NumberFormat.getNumberInstance(Locale.ROOT).format(TimeControllerEntity.this.bar.getMaxProgress())));
                        return Arrays.asList(var10000);
                    }
                });
            }
        }.setCanIncrease(tileEntity -> false).setCanReset(tileEntity -> false).setColor(DyeColor.PURPLE);
        this.addProgressBar(this.bar);
        this.addButton(new ArrowButtonComponent(155, 23, 14, 14, FacingUtil.Sideness.TOP).setId(1).setPredicate((playerEntity, compoundNBT) -> {
            --this.choose;
            this.finish = false;
            if (this.choose < 0) {
                this.choose = times.length - 1;
            }
            if (times[this.choose].hasTexture()) {
                this.time = times[this.choose].getTime();
            }
            this.markForUpdate();
        }));
        this.addButton(new ArrowButtonComponent(155, 60, 14, 14, FacingUtil.Sideness.BOTTOM).setId(2).setPredicate((playerEntity, compoundNBT) -> {
            ++this.choose;
            this.finish = false;
            if (this.choose > times.length - 1) {
                this.choose = 0;
            }
            if (times[this.choose].hasTexture()) {
                this.time = times[this.choose].getTime();
            }
            this.markForUpdate();
        }));
        this.addButton(new ArrowButtonComponent(79, 20, 14, 14, FacingUtil.Sideness.LEFT).setId(3).setPredicate((playerEntity, compoundNBT) -> {
            if (times[this.choose].hasTexture()) {
                this.time = times[this.choose].getTime();
            } else if (isShiftDown && !isCtrlDown) {
                this.time -= 10L;
            } else if (!isShiftDown && isCtrlDown) {
                this.time -= 100L;
            } else if (isShiftDown) {
                this.time -= 1000L;
            } else if (!isShiftDown && !isCtrlDown) {
                --this.time;
            }
            this.finish = false;
            this.markForUpdate();
        }));
        this.addButton(new ArrowButtonComponent(135, 20, 14, 14, FacingUtil.Sideness.RIGHT).setId(4).setPredicate((playerEntity, compoundNBT) -> {
            if (times[this.choose].hasTexture()) {
                this.time = times[this.choose].getTime();
            } else if (isShiftDown && !isCtrlDown) {
                this.time += 10L;
            } else if (!isShiftDown && isCtrlDown) {
                this.time += 100L;
            } else if (isShiftDown && isCtrlDown) {
                this.time += 1000L;
            } else if (!isShiftDown && !isCtrlDown) {
                ++this.time;
            }
            this.finish = false;
            this.markForUpdate();
        }));
        this.addButton(new ButtonComponent(136, 84, 14, 14){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> {
                    StateButtonInfo[] buttonInfo = new StateButtonInfo[2];
                    IAssetType asset = AssetTypes.BUTTON_SIDENESS_ENABLED;
                    String[] tip = new String[2];
                    ChatFormatting chatFormatting = ChatFormatting.GOLD;
                    tip[0] = chatFormatting + LangUtil.getString((String)"tooltip.ifeu.time_controller.has_tip", (Object[])new Object[0]);
                    tip[1] = "tooltip.ifeu.time_controller.has_tip_1";
                    buttonInfo[0] = new StateButtonInfo(0, asset, tip);
                    asset = AssetTypes.BUTTON_SIDENESS_DISABLED;
                    tip = new String[]{chatFormatting + LangUtil.getString((String)"tooltip.ifeu.time_controller.without_tip", (Object[])new Object[0]), "tooltip.ifeu.time_controller.without_tip_1"};
                    buttonInfo[1] = new StateButtonInfo(1, asset, tip);
                    return new StateButtonAddon(this, buttonInfo){

                        public int getState() {
                            return TimeControllerEntity.this.hasButtonTip ? 0 : 1;
                        }
                    };
                });
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            this.hasButtonTip = !this.hasButtonTip;
            this.markForUpdate();
        }).setId(5));
        this.powerPerTick = TimeControllerConfig.powerPerTick;
    }

    public void clientTick(Level level, BlockPos pos, BlockState state, TimeControllerEntity blockEntity) {
        if (this.choose > times.length - 1) {
            this.choose = 0;
        } else if (this.choose < 0) {
            this.choose = times.length - 1;
        }
        if (this.time < 0L) {
            this.time = 0L;
        }
        if (level.m_5776_()) {
            isShiftDown = KeyDownUtil.isShiftKeyDown();
            isCtrlDown = KeyDownUtil.isCtrlKeyDown();
            ModNetWorking.sendToServer(new TimeControllerEntityKeyDownSyncC2SPacket(isShiftDown, isCtrlDown));
        }
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, TimeControllerEntity blockEntity) {
        super.serverTick(level, pos, state, (ActiveTile)blockEntity);
        if (this.time < 0L) {
            this.time = 0L;
        }
        if (!level.m_5776_()) {
            ModNetWorking.sendToClient(new BooleanSyncS2CPacket(pos, this.finish));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        this.addGuiAddonFactory(() -> new TextureGuiComponent(155, 41){

            @Override
            public AllGuiTextures getTexture() {
                return times[TimeControllerEntity.this.choose].getTexture();
            }

            @Override
            public Component getComponent() {
                if (times[TimeControllerEntity.this.choose].hasTexture()) {
                    return Component.m_237115_((String)("time.ifeu." + times[TimeControllerEntity.this.choose].getName()));
                }
                return Component.m_237119_();
            }
        });
        this.addGuiAddonFactory(() -> new TextGuiComponent(158, 42){

            @Override
            public String getText() {
                if (!times[TimeControllerEntity.this.choose].hasTexture()) {
                    return times[TimeControllerEntity.this.choose].getName();
                }
                return "";
            }
        });
        this.addGuiAddonFactory(() -> new TextGuiComponent(95, 22){

            @Override
            public String getText() {
                return String.valueOf(TimeControllerEntity.this.time);
            }
        });
        this.addGuiAddonFactory(() -> new TextureGuiComponent(98, 41){

            @Override
            public AllGuiTextures getTexture() {
                if (TimeControllerEntity.this.finish) {
                    return AllGuiTextures.TRUE;
                }
                return AllGuiTextures.EMPTY;
            }

            @Override
            public Component getComponent() {
                if (TimeControllerEntity.this.finish) {
                    return Component.m_237115_((String)"time.ifeu.finish");
                }
                return Component.m_237119_();
            }
        });
        this.addGuiAddonFactory(() -> new CustomTooltipComponent(79, 20){

            @Override
            public int[] width$height() {
                return new int[]{14, 14};
            }

            @Override
            public Component[] getComponents() {
                return 7.defaultKeyDownTips("reduce");
            }

            @Override
            public boolean hasTooltip() {
                return TimeControllerEntity.this.hasButtonTip;
            }
        });
        this.addGuiAddonFactory(() -> new CustomTooltipComponent(135, 20){

            @Override
            public int[] width$height() {
                return new int[]{14, 14};
            }

            @Override
            public Component[] getComponents() {
                return 8.defaultKeyDownTips("add");
            }

            @Override
            public boolean hasTooltip() {
                return TimeControllerEntity.this.hasButtonTip;
            }
        });
    }

    public boolean canIncrease() {
        this.increaseBar(this.input.getStackInSlot(0), this.bar);
        return this.bar.getProgress() >= 1;
    }

    private void increaseBar(ItemStack stack, ProgressBarComponent bar) {
        if (bar.getProgress() + 1 <= bar.getMaxProgress() && !stack.m_41619_()) {
            stack.m_41774_(1);
            bar.setProgress(bar.getProgress() + 1);
            this.markForUpdate();
        }
    }

    public Runnable onFinish() {
        return () -> {
            this.bar.setProgress(this.bar.getProgress() - 1);
            times[this.choose].modifyTime(this.time);
            times[this.choose].setTime((ServerLevel)this.f_58857_);
            this.finish = true;
            this.markForUpdate();
        };
    }

    protected int getTickPower() {
        return this.powerPerTick;
    }

    @NotNull
    public TimeControllerEntity getSelf() {
        return this;
    }

    public void loadSettings(Player player, CompoundTag tag) {
        if (tag.m_128441_("time")) {
            this.time = tag.m_128454_("time");
        }
        if (tag.m_128441_("choose")) {
            this.choose = tag.m_128451_("choose");
        }
        if (tag.m_128441_("hideButtonTip")) {
            this.hasButtonTip = tag.m_128471_("hideButtonTip");
        }
        super.loadSettings(player, tag);
    }

    public void saveSettings(Player player, CompoundTag tag) {
        tag.m_128356_("time", this.time);
        tag.m_128405_("choose", this.choose);
        tag.m_128379_("hideButtonTip", this.hasButtonTip);
        super.saveSettings(player, tag);
    }

    @Override
    public void setValue(boolean ... value) {
        this.finish = value[0];
    }

    @Override
    public boolean[] getValues() {
        return new boolean[]{this.finish};
    }
}

