/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.block.entity;

import com.buuz135.industrial.block.tile.IndustrialProcessingTile;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAssetType;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.client.screen.addon.StateButtonAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonInfo;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.util.LangUtil;
import com.hrznstudio.titanium.util.RecipeUtil;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.yxiao233.ifeu.common.config.machine.FluidCraftingTableConfig;
import net.yxiao233.ifeu.common.recipe.ShapedRecipe;
import net.yxiao233.ifeu.common.recipe.ShapelessRecipe;
import net.yxiao233.ifeu.common.registry.ModBlocks;
import net.yxiao233.ifeu.common.registry.ModRecipes;
import org.jetbrains.annotations.NotNull;

public class FluidCraftingTableEntity
extends IndustrialProcessingTile<FluidCraftingTableEntity> {
    @Save
    public InventoryComponent<FluidCraftingTableEntity> inputs;
    @Save
    public SidedFluidTankComponent<FluidCraftingTableEntity> inputFluid;
    @Save
    private SidedInventoryComponent<FluidCraftingTableEntity> output;
    public ShapedRecipe shapedRecipe;
    public ShapelessRecipe shapelessRecipe;
    public boolean shapedOnFinish;
    public boolean shapelessOnFinish;
    public FluidStack shapedFluidWillBeDrained;
    public FluidStack shapelessFluidWillBeDrained;
    public ShapedRecipe lastTimeShapedRecipe;
    public ShapelessRecipe lastTimeShapelessRecipe;
    private ButtonComponent buttonComponent1;
    private ButtonComponent buttonComponent2;
    @Save
    public boolean autoCraft = false;
    @Save
    public boolean isFluidRender = true;

    public FluidCraftingTableEntity(BlockPos blockPos, BlockState blockState) {
        super(ModBlocks.FLUID_CRAFTING_TABLE, 102, 41, blockPos, blockState);
        int slotSpacing = 22;
        this.inputs = new InventoryComponent("input", 19 + slotSpacing, slotSpacing, 9).setSlotToColorRender(0, DyeColor.LIGHT_BLUE).setSlotToColorRender(1, DyeColor.LIGHT_BLUE).setSlotToColorRender(2, DyeColor.LIGHT_BLUE).setSlotToColorRender(3, DyeColor.LIGHT_BLUE).setSlotToColorRender(4, DyeColor.LIGHT_BLUE).setSlotToColorRender(5, DyeColor.LIGHT_BLUE).setSlotToColorRender(6, DyeColor.LIGHT_BLUE).setSlotToColorRender(7, DyeColor.LIGHT_BLUE).setSlotToColorRender(8, DyeColor.LIGHT_BLUE).setRange(3, 3).setOutputFilter((itemStack, integer) -> false).setOnSlotChanged((itemStack, integer) -> this.checkForRecipe()).setSlotLimit(1).setInputFilter((itemStack, integer) -> this.output.getStackInSlot(0).m_41619_()).setComponentHarness((IComponentHarness)this);
        this.addInventory(this.inputs);
        this.output = (SidedInventoryComponent)new SidedInventoryComponent("ot", 129, 18 + slotSpacing, 1, 1).setColor(DyeColor.ORANGE).setRange(1, 1).setInputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.output);
        this.inputFluid = (SidedFluidTankComponent)new SidedFluidTankComponent("input_fluid", FluidCraftingTableConfig.maxInputTankSize, 17, 19, 0).setColor(DyeColor.LIME).setTankType(FluidTankComponent.Type.NORMAL).setComponentHarness((IComponentHarness)this).setOnContentChange(() -> this.checkForRecipe());
        this.addTank((FluidTankComponent)this.inputFluid);
        this.buttonComponent1 = new ButtonComponent(136, 84, 14, 14){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> {
                    StateButtonInfo[] buttonInfo = new StateButtonInfo[2];
                    IAssetType asset = AssetTypes.BUTTON_SIDENESS_ENABLED;
                    String[] tip = new String[2];
                    ChatFormatting chatFormatting = ChatFormatting.GOLD;
                    tip[0] = chatFormatting + LangUtil.getString((String)"tooltip.ifeu.fluid_crafting_table.auto_craft", (Object[])new Object[0]);
                    tip[1] = "tooltip.ifeu.fluid_crafting_table.auto_craft_1";
                    buttonInfo[0] = new StateButtonInfo(0, asset, tip);
                    asset = AssetTypes.BUTTON_SIDENESS_DISABLED;
                    tip = new String[]{chatFormatting + LangUtil.getString((String)"tooltip.ifeu.fluid_crafting_table.original", (Object[])new Object[0]), "tooltip.ifeu.fluid_crafting_table.original_1"};
                    buttonInfo[1] = new StateButtonInfo(1, asset, tip);
                    return new StateButtonAddon(this, buttonInfo){

                        public int getState() {
                            return FluidCraftingTableEntity.this.autoCraft ? 0 : 1;
                        }
                    };
                });
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            this.autoCraft = !this.autoCraft;
            this.markForUpdate();
        }).setId(1);
        this.addButton(this.buttonComponent1);
        this.buttonComponent2 = new ButtonComponent(120, 84, 14, 14){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> {
                    StateButtonInfo[] buttonInfo = new StateButtonInfo[2];
                    IAssetType asset = AssetTypes.BUTTON_SIDENESS_ENABLED;
                    String[] tip = new String[2];
                    ChatFormatting chatFormatting = ChatFormatting.GOLD;
                    tip[0] = chatFormatting + LangUtil.getString((String)"tooltip.ifeu.fluid_crafting_table.render_fluid", (Object[])new Object[0]);
                    tip[1] = "tooltip.ifeu.fluid_crafting_table.render_fluid_1";
                    buttonInfo[0] = new StateButtonInfo(0, asset, tip);
                    asset = AssetTypes.BUTTON_SIDENESS_DISABLED;
                    tip = new String[]{chatFormatting + LangUtil.getString((String)"tooltip.ifeu.fluid_crafting_table.not_render_fluid", (Object[])new Object[0]), "tooltip.ifeu.fluid_crafting_table.not_render_fluid_1"};
                    buttonInfo[1] = new StateButtonInfo(1, asset, tip);
                    return new StateButtonAddon(this, buttonInfo){

                        public int getState() {
                            return FluidCraftingTableEntity.this.isFluidRender ? 0 : 1;
                        }
                    };
                });
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            this.isFluidRender = !this.isFluidRender;
            this.markForUpdate();
        }).setId(2);
        this.addButton(this.buttonComponent2);
    }

    public boolean canIncrease() {
        if (this.shapedRecipe != null) {
            if (this.autoCraft) {
                return ItemHandlerHelper.insertItem(this.output, (ItemStack)this.shapedRecipe.output.m_41777_(), (boolean)true).m_41619_();
            }
            return ItemHandlerHelper.insertItem(this.output, (ItemStack)this.shapedRecipe.output.m_41777_(), (boolean)true).m_41619_() && !this.shapedOnFinish;
        }
        if (this.shapelessRecipe != null) {
            if (this.autoCraft) {
                return ItemHandlerHelper.insertItem(this.output, (ItemStack)this.shapelessRecipe.output.m_41777_(), (boolean)true).m_41619_();
            }
            return ItemHandlerHelper.insertItem(this.output, (ItemStack)this.shapelessRecipe.output.m_41777_(), (boolean)true).m_41619_() && !this.shapelessOnFinish;
        }
        return false;
    }

    private void checkForRecipe() {
        if (this.isServer()) {
            if (this.shapelessRecipe != null && this.shapelessRecipe.matches(this.inputs, (FluidTankComponent<FluidCraftingTableEntity>)this.inputFluid)) {
                return;
            }
            if (this.shapedRecipe != null && this.shapedRecipe.matches(this.inputs, (FluidTankComponent<FluidCraftingTableEntity>)this.inputFluid)) {
                return;
            }
            this.shapelessRecipe = RecipeUtil.getRecipes((Level)this.f_58857_, (RecipeType)((RecipeType)ModRecipes.SHAPELESS_TYPE.get())).stream().filter(recipe -> recipe.matches(this.inputs, (FluidTankComponent<FluidCraftingTableEntity>)this.inputFluid)).findFirst().orElse(null);
            if (this.shapelessRecipe == null) {
                this.shapedRecipe = RecipeUtil.getRecipes((Level)this.f_58857_, (RecipeType)((RecipeType)ModRecipes.SHAPED_TYPE.get())).stream().filter(recipe -> recipe.matches(this.inputs, (FluidTankComponent<FluidCraftingTableEntity>)this.inputFluid)).findFirst().orElse(null);
            }
        }
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, FluidCraftingTableEntity blockEntity) {
        super.serverTick(level, pos, state, (ActiveTile)blockEntity);
        if (!this.autoCraft) {
            if (this.shapedOnFinish && (this.output.getStackInSlot(0).m_41619_() || this.output.getStackInSlot(0).m_41613_() < this.lastTimeShapedRecipe.output.m_41613_())) {
                for (int i = 0; i < this.inputs.getSlots(); ++i) {
                    this.inputs.getStackInSlot(i).m_41774_(1);
                }
                this.inputFluid.drainForced(this.shapedFluidWillBeDrained, IFluidHandler.FluidAction.EXECUTE);
                this.shapedOnFinish = false;
                this.shapedFluidWillBeDrained = null;
                this.lastTimeShapedRecipe = null;
                this.checkForRecipe();
            } else if (this.shapelessOnFinish && (this.output.getStackInSlot(0).m_41619_() || this.output.getStackInSlot(0).m_41613_() < this.lastTimeShapelessRecipe.output.m_41613_())) {
                for (int i = 0; i < this.inputs.getSlots(); ++i) {
                    this.inputs.getStackInSlot(i).m_41774_(1);
                }
                this.inputFluid.drainForced(this.shapelessFluidWillBeDrained, IFluidHandler.FluidAction.EXECUTE);
                this.shapelessOnFinish = false;
                this.shapedFluidWillBeDrained = null;
                this.lastTimeShapelessRecipe = null;
                this.checkForRecipe();
            }
            if (this.lastTimeShapedRecipe != null && this.lastTimeShapelessRecipe == null && this.shapedOnFinish && !this.lastTimeShapedRecipe.matches(this.inputs, (FluidTankComponent<FluidCraftingTableEntity>)this.inputFluid)) {
                this.output.setStackInSlot(0, ItemStack.f_41583_);
                this.shapedOnFinish = false;
                this.shapedFluidWillBeDrained = null;
                this.lastTimeShapedRecipe = null;
                this.checkForRecipe();
            }
            if (this.lastTimeShapedRecipe == null && this.lastTimeShapelessRecipe == null && !this.isInputSlotsAllMatchEmpty()) {
                this.output.setStackInSlot(0, ItemStack.f_41583_);
                this.shapedOnFinish = false;
                this.shapedFluidWillBeDrained = null;
                this.checkForRecipe();
            }
            if (this.lastTimeShapelessRecipe != null && this.lastTimeShapedRecipe == null && this.shapelessOnFinish && !this.lastTimeShapelessRecipe.matches(this.inputs, (FluidTankComponent<FluidCraftingTableEntity>)this.inputFluid)) {
                this.output.setStackInSlot(0, ItemStack.f_41583_);
                this.shapelessOnFinish = false;
                this.shapelessFluidWillBeDrained = null;
                this.lastTimeShapelessRecipe = null;
                this.checkForRecipe();
            }
            if (this.lastTimeShapelessRecipe == null && this.lastTimeShapedRecipe == null && !this.isInputSlotsAllMatchEmpty()) {
                this.output.setStackInSlot(0, ItemStack.f_41583_);
                this.shapelessOnFinish = false;
                this.shapelessFluidWillBeDrained = null;
                this.checkForRecipe();
            }
        } else if (this.shapedOnFinish && this.lastTimeShapedRecipe != null) {
            for (int i = 0; i < this.inputs.getSlots(); ++i) {
                this.inputs.getStackInSlot(i).m_41774_(1);
            }
            this.inputFluid.drainForced(this.lastTimeShapedRecipe.inputFluid, IFluidHandler.FluidAction.EXECUTE);
            this.shapedOnFinish = false;
            this.shapedFluidWillBeDrained = null;
            this.lastTimeShapedRecipe = null;
            this.checkForRecipe();
        } else if (this.shapelessOnFinish && this.lastTimeShapelessRecipe != null) {
            for (int i = 0; i < this.inputs.getSlots(); ++i) {
                this.inputs.getStackInSlot(i).m_41774_(1);
            }
            this.inputFluid.drainForced(this.lastTimeShapelessRecipe.inputFluid, IFluidHandler.FluidAction.EXECUTE);
            this.shapelessOnFinish = false;
            this.shapedFluidWillBeDrained = null;
            this.lastTimeShapelessRecipe = null;
            this.checkForRecipe();
        }
    }

    private boolean isInputSlotsAllMatchEmpty() {
        boolean allMatch = false;
        for (int i = 0; i < this.inputs.getSlots(); ++i) {
            if (!this.inputs.getStackInSlot(i).m_41619_()) {
                return false;
            }
            allMatch = true;
        }
        return allMatch;
    }

    public Runnable onFinish() {
        return () -> {
            if (this.shapedRecipe != null && this.output.getStackInSlot(0).m_41619_()) {
                ShapedRecipe shapedRecipe = this.shapedRecipe;
                this.shapedOnFinish = true;
                this.shapedFluidWillBeDrained = shapedRecipe.inputFluid;
                this.lastTimeShapedRecipe = shapedRecipe;
                ItemStack outputStack = shapedRecipe.output.m_41777_();
                outputStack.m_41720_().m_7836_(outputStack, this.f_58857_, null);
                ItemHandlerHelper.insertItem(this.output, (ItemStack)outputStack, (boolean)false);
            } else if (this.shapelessRecipe != null && this.output.getStackInSlot(0).m_41619_()) {
                ShapelessRecipe shapelessRecipe = this.shapelessRecipe;
                this.shapelessOnFinish = true;
                this.shapelessFluidWillBeDrained = shapelessRecipe.inputFluid;
                this.lastTimeShapelessRecipe = shapelessRecipe;
                ItemStack outputStack = shapelessRecipe.output.m_41777_();
                outputStack.m_41720_().m_7836_(outputStack, this.f_58857_, null);
                ItemHandlerHelper.insertItem(this.output, (ItemStack)outputStack, (boolean)false);
            }
        };
    }

    public int getMaxProgress() {
        return 1;
    }

    @NotNull
    public FluidCraftingTableEntity getSelf() {
        return this;
    }

    @NotNull
    protected EnergyStorageComponent<FluidCraftingTableEntity> createEnergyStorage() {
        return new EnergyStorageComponent(0, 0, 0, -1000, -1000);
    }

    public void m_6596_() {
        super.m_6596_();
        this.checkForRecipe();
    }

    public void m_142339_(Level p_155231_) {
        super.m_142339_(p_155231_);
        this.checkForRecipe();
    }

    protected int getTickPower() {
        return 0;
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128379_("shaped_on_finish", this.shapedOnFinish);
        compoundTag.m_128379_("shapeless_on_finish", this.shapelessOnFinish);
        compoundTag.m_128379_("auto_craft", this.autoCraft);
        compoundTag.m_128379_("is_render_fluid", this.isFluidRender);
    }

    public void loadSettings(Player player, CompoundTag tag) {
        super.loadSettings(player, tag);
        this.shapedOnFinish = tag.m_128471_("shaped_on_finish");
        this.shapelessOnFinish = tag.m_128471_("shapeless_on_finish");
        this.autoCraft = tag.m_128471_("auto_craft");
        this.isFluidRender = tag.m_128471_("is_render_fluid");
    }
}

