/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.api.fluid;

import com.hrznstudio.titanium.module.DeferredRegistryHelper;
import com.hrznstudio.titanium.tab.TitaniumTab;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.yxiao233.ifeu.api.fluid.AbstractAnimateFluid;

public abstract class AbstractAnimateFluidInstance {
    private RegistryObject<FluidType> fluidType;
    private RegistryObject<Fluid> flowingFluid;
    private RegistryObject<Fluid> sourceFluid;
    private RegistryObject<Item> bucketFluid;
    private RegistryObject<Block> blockFluid;
    private final String fluid;

    public AbstractAnimateFluidInstance(DeferredRegistryHelper helper, String fluid, FluidType.Properties fluidTypeProperties, final IClientFluidTypeExtensions renderProperties, @Nullable TitaniumTab group) {
        this.fluid = fluid;
        this.sourceFluid = helper.registerGeneric(ForgeRegistries.FLUIDS.getRegistryKey(), fluid, () -> this.setSource(this));
        this.flowingFluid = helper.registerGeneric(ForgeRegistries.FLUIDS.getRegistryKey(), fluid + "_flowing", () -> this.setFlowing(this));
        this.fluidType = helper.registerGeneric(ForgeRegistries.Keys.FLUID_TYPES, fluid, () -> new FluidType(fluidTypeProperties){

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(renderProperties);
            }
        });
        this.bucketFluid = helper.registerGeneric(ForgeRegistries.ITEMS.getRegistryKey(), fluid + "_bucket", () -> {
            BucketItem item = new BucketItem(this.sourceFluid, new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1));
            if (group != null) {
                group.getTabList().add(item);
            }
            return item;
        });
        this.blockFluid = helper.registerGeneric(ForgeRegistries.BLOCKS.getRegistryKey(), fluid, () -> new LiquidBlock(() -> (FlowingFluid)this.sourceFluid.get(), BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283864_).m_280170_().m_60910_().m_60978_(100.0f).m_278166_(PushReaction.DESTROY).m_222994_().m_278788_().m_60918_(SoundType.f_279557_)));
    }

    public abstract AbstractAnimateFluid.Source<?> setSource(AbstractAnimateFluidInstance var1);

    public abstract AbstractAnimateFluid.Flowing<?> setFlowing(AbstractAnimateFluidInstance var1);

    public RegistryObject<FluidType> getFluidType() {
        return this.fluidType;
    }

    public RegistryObject<Fluid> getFlowingFluid() {
        return this.flowingFluid;
    }

    public RegistryObject<Fluid> getSourceFluid() {
        return this.sourceFluid;
    }

    public RegistryObject<Item> getBucketFluid() {
        return this.bucketFluid;
    }

    public RegistryObject<Block> getBlockFluid() {
        return this.blockFluid;
    }

    public String getFluid() {
        return this.fluid;
    }
}

