/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.api.block.entity;

import com.hrznstudio.titanium.util.RecipeUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.RegistryObject;
import net.yxiao233.ifeu.api.block.entity.IFEUItemFuelGeneratorEntity;
import net.yxiao233.ifeu.api.recipe.ItemGeneratorSerializableRecipe;
import net.yxiao233.ifeu.common.utils.SlotElementsUtil;
import org.apache.commons.lang3.tuple.Pair;

public abstract class IFEUItemFuelJsonGeneratorEntity<T extends IFEUItemFuelJsonGeneratorEntity<T>>
extends IFEUItemFuelGeneratorEntity<T> {
    private ItemGeneratorSerializableRecipe recipe;

    public IFEUItemFuelJsonGeneratorEntity(Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> basicTileBlock, BlockPos blockPos, BlockState blockState) {
        super(basicTileBlock, blockPos, blockState);
    }

    public abstract <R extends ItemGeneratorSerializableRecipe> RecipeType<R> setRecipeType();

    @Override
    public SlotElementsUtil getSlotElements() {
        List list = RecipeUtil.getRecipes((Level)this.f_58857_, this.setRecipeType());
        ArrayList stacks = new ArrayList(list.size());
        list.forEach(recipe -> stacks.add(recipe.input));
        return new SlotElementsUtil().setInputFilter((stack, integer) -> stacks.contains(stack));
    }

    @Override
    public ItemStack getConsumeFuel() {
        return ItemStack.f_41583_;
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        super.serverTick(level, pos, state, blockEntity);
        this.checkForRecipe();
    }

    @Override
    public int consumeFuel() {
        if (this.recipe != null) {
            ItemStack stack = this.recipe.input;
            if (this.input.getStackInSlot(0).m_41613_() >= stack.m_41613_()) {
                this.input.extractItem(0, stack.m_41613_(), false);
                return this.recipe.progressTime;
            }
        } else {
            this.checkForRecipe();
        }
        return 0;
    }

    @Override
    public boolean canStart() {
        if (this.recipe != null) {
            return this.input.getStackInSlot(0).m_41613_() >= this.recipe.input.m_41613_() && this.getEnergyStorage().getEnergyStored() < this.getEnergyStorage().getMaxEnergyStored();
        }
        this.checkForRecipe();
        return false;
    }

    private void checkForRecipe() {
        if (this.isServer()) {
            if (this.recipe != null && this.recipe.matches((IItemHandler)this.input, this.getEnergyStorage())) {
                return;
            }
            this.recipe = RecipeUtil.getRecipes((Level)this.f_58857_, this.setRecipeType()).stream().filter(recipe -> recipe.matches((IItemHandler)this.input, this.getEnergyStorage())).findFirst().orElse(null);
        }
    }

    public void m_6596_() {
        super.m_6596_();
        this.checkForRecipe();
    }

    public void m_142339_(Level p_155231_) {
        super.m_142339_(p_155231_);
        this.checkForRecipe();
    }
}

