/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.api.block.entity;

import com.hrznstudio.titanium.util.RecipeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.RegistryObject;
import net.yxiao233.ifeu.api.block.entity.IFEUFluidFuelGeneratorEntity;
import net.yxiao233.ifeu.api.recipe.FluidGeneratorSerializableRecipe;
import net.yxiao233.ifeu.common.utils.FluidTankElementsUtil;
import org.apache.commons.lang3.tuple.Pair;

public abstract class IFEUFluidFuelJsonGeneratorEntity<T extends IFEUFluidFuelJsonGeneratorEntity<T>>
extends IFEUFluidFuelGeneratorEntity<T> {
    private FluidGeneratorSerializableRecipe recipe;

    public IFEUFluidFuelJsonGeneratorEntity(Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> basicTileBlock, BlockPos blockPos, BlockState blockState) {
        super(basicTileBlock, blockPos, blockState);
    }

    public abstract <R extends FluidGeneratorSerializableRecipe> RecipeType<R> setRecipeType();

    @Override
    public FluidTankElementsUtil getFluidTankElements() {
        return new FluidTankElementsUtil();
    }

    @Override
    public FluidStack getConsumeFuel() {
        return FluidStack.EMPTY;
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        super.serverTick(level, pos, state, blockEntity);
        this.checkForRecipe();
    }

    @Override
    public int consumeFuel() {
        if (this.recipe != null && this.extraStartCondition()) {
            FluidStack stack = this.recipe.inputFluid;
            if (this.inputFluid.getFluid().isFluidEqual(stack)) {
                this.inputFluid.drainForced(stack, IFluidHandler.FluidAction.EXECUTE);
                return this.recipe.progressTime;
            }
        } else {
            this.checkForRecipe();
        }
        return 0;
    }

    @Override
    public boolean canStart() {
        if (this.recipe != null && this.extraStartCondition()) {
            return this.inputFluid.getFluid().isFluidEqual(this.recipe.inputFluid) && this.getEnergyStorage().getEnergyStored() < this.getEnergyStorage().getMaxEnergyStored();
        }
        this.checkForRecipe();
        return false;
    }

    private void checkForRecipe() {
        if (this.isServer()) {
            if (this.recipe != null && this.recipe.matches((IFluidHandler)this.inputFluid, this.getEnergyStorage())) {
                return;
            }
            this.recipe = RecipeUtil.getRecipes((Level)this.f_58857_, this.setRecipeType()).stream().filter(recipe -> recipe.matches((IFluidHandler)this.inputFluid, this.getEnergyStorage())).findFirst().orElse(null);
        }
    }

    public void m_6596_() {
        super.m_6596_();
        this.checkForRecipe();
    }

    public void m_142339_(Level p_155231_) {
        super.m_142339_(p_155231_);
        this.checkForRecipe();
    }
}

