/*
 * Decompiled with CFR 0.152.
 */
package dev.wuffs.squatgrow;

import com.google.common.collect.ImmutableSet;
import dev.wuffs.squatgrow.SquatGrow;
import dev.wuffs.squatgrow.actions.Action;
import dev.wuffs.squatgrow.actions.ActionContext;
import dev.wuffs.squatgrow.actions.Actions;
import dev.wuffs.squatgrow.config.SquatGrowConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;

public class SquatAction {
    public static void performAction(Level level, Player player) {
        if (level.f_46443_) {
            return;
        }
        if (!SquatGrow.config.allowAdventureTwerking && ((ServerPlayer)player).f_8941_.m_9290_() == GameType.ADVENTURE) {
            return;
        }
        Pair<Boolean, List<ItemStack>> requirementsTest = SquatAction.passesRequirements(player);
        if (!((Boolean)requirementsTest.getKey()).booleanValue()) {
            return;
        }
        SquatAction.grow(level, (ServerPlayer)player, (List)requirementsTest.getValue());
    }

    public static Pair<Boolean, List<ItemStack>> passesRequirements(Player player) {
        ArrayList<ItemStack> itemsThatHandleDamage = new ArrayList<ItemStack>();
        if (SquatGrow.config.requireHoe) {
            ItemStack matchedItem = SquatAction.getMatchingHeldItem(player, Collections.emptyList(), List.of(ItemTags.f_271298_));
            if (!matchedItem.m_41619_()) {
                itemsThatHandleDamage.add(matchedItem);
                return Pair.of((Object)true, itemsThatHandleDamage);
            }
            return Pair.of((Object)false, itemsThatHandleDamage);
        }
        SquatGrowConfig.Requirements requirements = SquatGrow.config.requirements;
        if (requirements.enabled && SquatGrow.computedRequirements != null) {
            List<ItemStack> matchingEquipment;
            if (requirements.heldItemRequirement.isEmpty() && requirements.equipmentRequirement.isEmpty()) {
                return Pair.of((Object)true, itemsThatHandleDamage);
            }
            boolean passesEquipment = false;
            if (!requirements.equipmentRequirement.isEmpty() && (matchingEquipment = SquatAction.matchingEquipmentItem(player, SquatGrow.computedRequirements.equipmentRequirementStacks(), SquatGrow.computedRequirements.equipmentRequirementTags())).size() == requirements.equipmentRequirement.size()) {
                itemsThatHandleDamage.addAll(matchingEquipment);
                passesEquipment = true;
            }
            if (!requirements.equipmentRequirement.isEmpty() && !passesEquipment) {
                return Pair.of((Object)false, itemsThatHandleDamage);
            }
            boolean passedHeldItem = false;
            ItemStack matchingHeldItem = SquatAction.getMatchingHeldItem(player, SquatGrow.computedRequirements.heldItemRequirementStacks(), SquatGrow.computedRequirements.heldItemRequirementTags());
            if (!matchingHeldItem.m_41619_()) {
                itemsThatHandleDamage.add(matchingHeldItem);
                passedHeldItem = true;
            }
            if (!requirements.heldItemRequirement.isEmpty() && !passedHeldItem) {
                return Pair.of((Object)false, itemsThatHandleDamage);
            }
            return Pair.of((Object)true, itemsThatHandleDamage);
        }
        return Pair.of((Object)true, Collections.emptyList());
    }

    public static void grow(Level level, ServerPlayer player, List<ItemStack> itemsToDamage) {
        BlockPos pos = player.m_20183_();
        RandomSource r = level.f_46441_;
        ImmutableSet<Action> actions = Actions.get().getActions();
        for (int x = -SquatGrow.config.range; x <= SquatGrow.config.range; ++x) {
            for (int z = -SquatGrow.config.range; z <= SquatGrow.config.range; ++z) {
                for (int y = -1; y <= 1; ++y) {
                    double randomValue = 0.0 + 1.0 * r.m_188500_();
                    if ((double)SquatGrow.config.chance < randomValue) continue;
                    boolean didGrow = false;
                    BlockPos offsetLocation = pos.m_7918_(x, y, z);
                    BlockState offsetState = level.m_8055_(offsetLocation);
                    if (offsetState.m_60795_() || !SquatGrow.allowTwerk(offsetState).booleanValue()) continue;
                    ActionContext context = new ActionContext(level, offsetLocation, offsetState, player.m_21205_(), player.m_21206_(), (Player)player);
                    for (Action action : actions) {
                        if (!action.canApply(context)) continue;
                        didGrow = action.execute(context);
                    }
                    if ((SquatGrow.config.hoeTakesDamage || SquatGrow.config.requirements.requiredItemTakesDamage) && didGrow && !itemsToDamage.isEmpty()) {
                        int durabilityToApply = SquatGrow.config.hoeTakesDamage ? 1 : SquatGrow.config.requirements.durabilityDamage;
                        for (ItemStack item : itemsToDamage) {
                            item.m_41622_(durabilityToApply, (LivingEntity)player, playerEntity -> playerEntity.m_21190_(player.m_7655_()));
                        }
                    }
                    if (!didGrow) continue;
                    SquatAction.addGrowthParticles((ServerLevel)level, offsetLocation, player);
                }
            }
        }
    }

    private static void addGrowthParticles(ServerLevel level, BlockPos pos, ServerPlayer player) {
        RandomSource random = level.f_46441_;
        int numParticles = 2;
        BlockState blockstate = level.m_8055_(pos);
        if (!blockstate.m_60795_()) {
            double d1;
            double d0 = 0.5;
            if (blockstate.m_60713_(Blocks.f_49990_)) {
                numParticles *= 3;
                d1 = 1.0;
                d0 = 3.0;
            } else if (blockstate.m_60804_((BlockGetter)level, pos)) {
                pos = pos.m_7494_();
                numParticles *= 3;
                d0 = 3.0;
                d1 = 1.0;
            } else {
                d1 = blockstate.m_60808_((BlockGetter)level, pos).m_83297_(Direction.Axis.Y);
            }
            int randomPartialCount = random.m_216339_(1, numParticles);
            BlockPos immutablePos = pos.m_7949_();
            for (int i = 0; i < randomPartialCount; ++i) {
                double d2 = random.m_188583_() * 0.2;
                double d3 = random.m_188583_() * 0.2;
                double d4 = random.m_188583_() * 0.2;
                double randomY = Mth.m_14008_((double)random.m_188500_(), (double)0.1, (double)0.5);
                double x = (double)immutablePos.m_123341_() + Mth.m_14008_((double)random.m_188500_(), (double)-1.0, (double)1.0);
                double y = (double)immutablePos.m_123342_() - 0.95 + (d1 + randomY);
                double z = (double)immutablePos.m_123343_() + Mth.m_14008_((double)random.m_188500_(), (double)-1.0, (double)1.0);
                BlockState state = level.m_8055_(immutablePos);
                if (state.m_60795_()) continue;
                level.m_8624_(player, (ParticleOptions)ParticleTypes.f_123748_, false, x, y, z, numParticles, d2, d3, d4, 0.5);
            }
            level.m_5594_(null, immutablePos, SoundEvents.f_144074_, SoundSource.MASTER, 0.5f, 1.0f);
        }
    }

    private static ItemStack getMatchingHeldItem(Player player, List<ItemStack> itemStacks, List<TagKey<Item>> itemTags) {
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        ItemStack matchingItem = SquatAction.compareItemToLists(mainHand, itemStacks, itemTags);
        if (!matchingItem.m_41619_()) {
            return matchingItem;
        }
        return SquatAction.compareItemToLists(offHand, itemStacks, itemTags);
    }

    private static ItemStack compareItemToLists(ItemStack stack, List<ItemStack> itemStacks, List<TagKey<Item>> itemTags) {
        for (ItemStack itemStack : itemStacks) {
            if (!SquatAction.itemStackMatches(stack, itemStack)) continue;
            return stack;
        }
        for (TagKey tagKey : itemTags) {
            if (!SquatAction.itemStackMatches(stack, (TagKey<Item>)tagKey)) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    private static List<ItemStack> matchingEquipmentItem(Player player, Map<EquipmentSlot, ItemStack> equipmentStacks, Map<EquipmentSlot, TagKey<Item>> equipmentTags) {
        ItemStack itemBySlot;
        ArrayList<ItemStack> matchedItems = new ArrayList<ItemStack>();
        for (Map.Entry<EquipmentSlot, ItemStack> entry : equipmentStacks.entrySet()) {
            itemBySlot = player.m_6844_(entry.getKey());
            if (!SquatAction.itemStackMatches(itemBySlot, entry.getValue())) continue;
            matchedItems.add(itemBySlot);
        }
        for (Map.Entry<EquipmentSlot, ItemStack> entry : equipmentTags.entrySet()) {
            itemBySlot = player.m_6844_(entry.getKey());
            if (!SquatAction.itemStackMatches(itemBySlot, (TagKey<Item>)((TagKey)entry.getValue()))) continue;
            matchedItems.add(itemBySlot);
        }
        return matchedItems;
    }

    private static boolean itemStackMatches(ItemStack stack, TagKey<Item> tag) {
        if (SquatGrow.computedEnchantment != null && stack.m_41792_()) {
            return stack.m_204117_(tag) && EnchantmentHelper.m_44831_((ItemStack)stack).containsKey(SquatGrow.computedEnchantment);
        }
        return stack.m_204117_(tag);
    }

    private static boolean itemStackMatches(ItemStack stack, ItemStack item) {
        if (SquatGrow.computedEnchantment != null && stack.m_41792_()) {
            return stack.m_150930_(item.m_41720_()) && EnchantmentHelper.m_44831_((ItemStack)stack).containsKey(SquatGrow.computedEnchantment);
        }
        return stack.m_150930_(item.m_41720_());
    }
}

