/*
 * Decompiled with CFR 0.152.
 */
package appbot.ae2;

import appbot.AppliedBotanics;
import appbot.Lookup;
import appbot.ae2.ManaHelper;
import appbot.ae2.ManaKey;
import appbot.ae2.ManaKeyType;
import appeng.api.behaviors.StackImportStrategy;
import appeng.api.behaviors.StackTransferContext;
import appeng.api.config.Actionable;
import appeng.api.networking.storage.IStorageService;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vazkii.botania.api.mana.ManaReceiver;

public class ManaStorageImportStrategy
implements StackImportStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManaStorageImportStrategy.class);
    private final Lookup<ManaReceiver, Direction> apiCache;
    private final Direction fromSide;

    public ManaStorageImportStrategy(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        this.apiCache = AppliedBotanics.getInstance().manaReceiver(level, fromPos);
        this.fromSide = fromSide;
    }

    public boolean transfer(StackTransferContext context) {
        int inserted;
        if (!context.isKeyTypeEnabled(ManaKeyType.TYPE)) {
            return false;
        }
        ManaReceiver receiver = this.apiCache.find(this.fromSide);
        if (receiver == null) {
            return false;
        }
        long remainingTransferAmount = (long)context.getOperationsRemaining() * (long)ManaKeyType.TYPE.getAmountPerOperation();
        IStorageService inv = context.getInternalStorage();
        int amount = (int)Math.min(remainingTransferAmount, (long)receiver.getCurrentMana());
        if (amount > 0) {
            receiver.receiveMana(-amount);
        }
        if ((inserted = (int)inv.getInventory().insert(ManaKey.KEY, (long)amount, Actionable.MODULATE, context.getActionSource())) < amount) {
            int leftover = amount - inserted;
            int backfill = Math.min(leftover, ManaHelper.getCapacity(receiver) - receiver.getCurrentMana());
            if (backfill > 0) {
                receiver.receiveMana(backfill);
            }
            if (leftover > backfill) {
                LOGGER.error("Storage import issue, voided {} mana", (Object)(leftover - backfill));
            }
        }
        int opsUsed = Math.max(1, inserted / ManaKeyType.TYPE.getAmountPerOperation());
        context.reduceOperationsRemaining((long)opsUsed);
        return amount > 0;
    }
}

