/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.client;

import ad_astra_giselle_addon.common.config.EnchantmentsConfig;
import ad_astra_giselle_addon.common.enchantment.EnchantmentHelper2;
import ad_astra_giselle_addon.common.registry.AddonEnchantments;
import com.google.common.collect.Sets;
import earth.terrarium.botarium.util.CommonHooks;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;

public class EnchantedBookTooltipHelper {
    private static final Set<String> DESCRIPTION_MODS = Sets.newHashSet((Object[])new String[]{"enchdesc", "enchantment_lore", "cofh_core"});

    public static boolean tooltipEnabled() {
        return EnchantmentsConfig.TOOLTIP_ENABLED && (EnchantmentsConfig.TOOLTIP_IGNORE || !EnchantedBookTooltipHelper.isDescriptionModsLoaded());
    }

    public static void addDescriptionMod(String modid) {
        DESCRIPTION_MODS.add(modid);
    }

    public static boolean isDescriptionModsLoaded() {
        for (String mod : DESCRIPTION_MODS) {
            if (!CommonHooks.isModLoaded((String)mod)) continue;
            return true;
        }
        return false;
    }

    public static Set<String> getDescriptionMods() {
        return Collections.unmodifiableSet(DESCRIPTION_MODS);
    }

    public static void addTooltip(ItemStack item, TooltipFlag flags, List<Component> lines) {
        if (item.m_41720_() instanceof EnchantedBookItem && EnchantedBookTooltipHelper.tooltipEnabled()) {
            block0: for (Enchantment enchantment : AddonEnchantments.ENCHANTMENTS.getValues()) {
                for (Component line : lines) {
                    TranslatableContents contents;
                    ComponentContents componentContents = line.m_214077_();
                    if (!(componentContents instanceof TranslatableContents) || !(contents = (TranslatableContents)componentContents).m_237508_().equals(enchantment.m_44704_())) continue;
                    lines.addAll(lines.indexOf(line) + 1, EnchantmentHelper2.getDescriptionTexts(enchantment));
                    continue block0;
                }
            }
        }
    }
}

