/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.smithing;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CyclingSlotBackground;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.SmithingScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.SBPTranslationHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.smithing.SmithingUpgradeContainer;
import net.p3pp3rf1y.sophisticatedcore.client.gui.StorageScreenBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.UpgradeSettingsTab;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TextureBlitData;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.UV;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import org.joml.Quaternionf;

public class SmithingUpgradeTab
extends UpgradeSettingsTab<SmithingUpgradeContainer> {
    public static final TextureBlitData ARROW = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(56, 221), new Dimension(14, 15));
    public static final TextureBlitData RED_CROSS = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(113, 216), new Dimension(15, 15));
    private final CyclingSlotBackground templateIcon;
    private final CyclingSlotBackground baseIcon;
    private final CyclingSlotBackground additionalIcon;
    private final ArmorStand armorStandPreview;

    public SmithingUpgradeTab(SmithingUpgradeContainer upgradeContainer, Position position, StorageScreenBase<?> screen) {
        super((UpgradeContainerBase)upgradeContainer, position, screen, (Component)SBPTranslationHelper.INSTANCE.translUpgrade("smithing", new Object[0]), SBPTranslationHelper.INSTANCE.translUpgradeTooltip("smithing"));
        this.openTabDimension = new Dimension(103, 100);
        this.armorStandPreview = new ArmorStand((Level)this.minecraft.f_91073_, 0.0, 0.0, 0.0);
        this.armorStandPreview.m_31678_(true);
        this.armorStandPreview.m_31675_(true);
        this.armorStandPreview.f_20883_ = 210.0f;
        this.armorStandPreview.m_146926_(25.0f);
        this.armorStandPreview.f_20885_ = this.armorStandPreview.m_146908_();
        this.armorStandPreview.f_20886_ = this.armorStandPreview.m_146908_();
        this.updateArmorStandPreview();
        this.templateIcon = new CyclingSlotBackground(((SmithingUpgradeContainer)this.getContainer()).getTemplateSlot().f_40219_);
        this.baseIcon = new CyclingSlotBackground(((SmithingUpgradeContainer)this.getContainer()).getBaseSlot().f_40219_);
        this.additionalIcon = new CyclingSlotBackground(((SmithingUpgradeContainer)this.getContainer()).getAdditionalSlot().f_40219_);
        ((SmithingUpgradeContainer)this.getContainer()).setOnResultChangedHandler(this::updateArmorStandPreview);
    }

    private void updateArmorStandPreview() {
        ItemStack stack = ((SmithingUpgradeContainer)this.getContainer()).getResultSlot().m_7993_();
        if (this.armorStandPreview != null) {
            for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
                this.armorStandPreview.m_8061_(equipmentslot, ItemStack.f_41583_);
            }
            if (!stack.m_41619_()) {
                ItemStack itemstack = stack.m_41777_();
                Item item = stack.m_41720_();
                if (item instanceof ArmorItem) {
                    ArmorItem armoritem = (ArmorItem)item;
                    this.armorStandPreview.m_8061_(armoritem.m_40402_(), itemstack);
                } else {
                    this.armorStandPreview.m_8061_(EquipmentSlot.OFFHAND, itemstack);
                }
            }
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, Minecraft minecraft, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, minecraft, mouseX, mouseY);
        if (((SmithingUpgradeContainer)this.getContainer()).isOpen()) {
            this.renderSlotBg(guiGraphics, ((SmithingUpgradeContainer)this.getContainer()).getTemplateSlot());
            this.renderSlotBg(guiGraphics, ((SmithingUpgradeContainer)this.getContainer()).getBaseSlot());
            this.renderSlotBg(guiGraphics, ((SmithingUpgradeContainer)this.getContainer()).getAdditionalSlot());
            this.renderSlotBg(guiGraphics, ((SmithingUpgradeContainer)this.getContainer()).getResultSlot());
            this.templateIcon.m_266270_(((StorageScreenBase)this.screen).m_6262_(), guiGraphics, 0.0f, ((StorageScreenBase)this.screen).getLeftX(), ((StorageScreenBase)this.screen).getTopY());
            this.baseIcon.m_266270_(((StorageScreenBase)this.screen).m_6262_(), guiGraphics, 0.0f, ((StorageScreenBase)this.screen).getLeftX(), ((StorageScreenBase)this.screen).getTopY());
            this.additionalIcon.m_266270_(((StorageScreenBase)this.screen).m_6262_(), guiGraphics, 0.0f, ((StorageScreenBase)this.screen).getLeftX(), ((StorageScreenBase)this.screen).getTopY());
        }
    }

    private void renderSlotBg(GuiGraphics guiGraphics, Slot slot) {
        GuiHelper.renderSlotsBackground((GuiGraphics)guiGraphics, (int)(slot.f_40220_ + ((StorageScreenBase)this.screen).getGuiLeft() - 1), (int)(slot.f_40221_ + ((StorageScreenBase)this.screen).getGuiTop() - 1), (int)1, (int)1);
    }

    public void renderTooltip(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(screen, guiGraphics, mouseX, mouseY);
        this.renderOnboardingTooltips(guiGraphics, mouseX, mouseY);
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
        if (!this.isOpen) {
            return;
        }
        Slot resultSlot = ((SmithingUpgradeContainer)this.getContainer()).getResultSlot();
        int inputSlotsY = resultSlot.f_40221_ + ((StorageScreenBase)this.screen).getGuiTop();
        int additionalSlotX = ((SmithingUpgradeContainer)this.getContainer()).getAdditionalSlot().f_40220_ + ((StorageScreenBase)this.screen).getGuiLeft();
        int resultSlotX = resultSlot.f_40220_ + ((StorageScreenBase)this.screen).getGuiLeft();
        int arrowX = this.getArrowX(additionalSlotX, resultSlotX);
        int arrowY = this.getArrowY(inputSlotsY);
        GuiHelper.blit((GuiGraphics)guiGraphics, (int)arrowX, (int)arrowY, (TextureBlitData)ARROW);
        if (this.hasRecipeError()) {
            GuiHelper.blit((GuiGraphics)guiGraphics, (int)arrowX, (int)arrowY, (TextureBlitData)RED_CROSS);
        }
        InventoryScreen.m_280432_((GuiGraphics)guiGraphics, (int)(this.getX() + this.getWidth() / 2), (int)(this.getTopY() + this.getHeight() - 10), (int)25, (Quaternionf)SmithingScreen.f_265867_, null, (LivingEntity)this.armorStandPreview);
    }

    private int getArrowY(int inputSlotsY) {
        return inputSlotsY + 1;
    }

    private int getArrowX(int additionalSlotX, int resultSlotX) {
        return additionalSlotX + 18 + (resultSlotX - (additionalSlotX + 18)) / 2 - ARROW.getWidth() / 2 - 1;
    }

    public void tick() {
        super.tick();
        this.templateIcon.m_266287_(SmithingScreen.f_265883_);
        ItemStack templateItem = ((SmithingUpgradeContainer)this.getContainer()).getTemplateSlot().m_7993_();
        Item item = templateItem.m_41720_();
        if (item instanceof SmithingTemplateItem) {
            SmithingTemplateItem smithingTemplate = (SmithingTemplateItem)item;
            this.baseIcon.m_266287_(smithingTemplate.m_266534_());
            this.additionalIcon.m_266287_(smithingTemplate.m_266326_());
        } else {
            this.baseIcon.m_266287_(List.of());
            this.additionalIcon.m_266287_(List.of());
        }
    }

    protected void moveSlotsToTab() {
        Slot templateSlot = ((SmithingUpgradeContainer)this.getContainer()).getTemplateSlot();
        templateSlot.f_40220_ = this.x - ((StorageScreenBase)this.screen).getGuiLeft() + 4;
        templateSlot.f_40221_ = this.y - ((StorageScreenBase)this.screen).getGuiTop() + 1 + 24;
        Slot baseSlot = ((SmithingUpgradeContainer)this.getContainer()).getBaseSlot();
        baseSlot.f_40220_ = templateSlot.f_40220_ + 18;
        baseSlot.f_40221_ = this.y - ((StorageScreenBase)this.screen).getGuiTop() + 1 + 24;
        Slot additionalSlot = ((SmithingUpgradeContainer)this.getContainer()).getAdditionalSlot();
        additionalSlot.f_40220_ = baseSlot.f_40220_ + 18;
        additionalSlot.f_40221_ = this.y - ((StorageScreenBase)this.screen).getGuiTop() + 1 + 24;
        Slot resultSlot = ((SmithingUpgradeContainer)this.getContainer()).getResultSlot();
        resultSlot.f_40220_ = this.x - ((StorageScreenBase)this.screen).getGuiLeft() + this.getWidth() - 2 - 3 - 18;
        resultSlot.f_40221_ = this.y - ((StorageScreenBase)this.screen).getGuiTop() + 1 + 24;
    }

    private boolean isHoveringRedCross(int mouseX, int mouseY) {
        Slot additionalSlot = ((SmithingUpgradeContainer)this.getContainer()).getAdditionalSlot();
        int arrowX = this.getArrowX(additionalSlot.f_40220_ + ((StorageScreenBase)this.screen).getGuiLeft(), ((SmithingUpgradeContainer)this.getContainer()).getResultSlot().f_40220_ + ((StorageScreenBase)this.screen).getGuiLeft());
        int arrowY = this.getArrowY(additionalSlot.f_40221_ + ((StorageScreenBase)this.screen).getGuiTop());
        return mouseX >= arrowX && mouseX < arrowX + RED_CROSS.getWidth() && mouseY >= arrowY && mouseY < arrowY + RED_CROSS.getHeight();
    }

    private boolean isHoveringEmptySlot(Slot slot, int mouseX, int mouseY) {
        return mouseX >= slot.f_40220_ + ((StorageScreenBase)this.screen).getGuiLeft() && mouseX < slot.f_40220_ + ((StorageScreenBase)this.screen).getGuiLeft() + 16 && mouseY >= slot.f_40221_ + ((StorageScreenBase)this.screen).getGuiTop() && mouseY < slot.f_40221_ + ((StorageScreenBase)this.screen).getGuiTop() + 16 && slot.m_7993_().m_41619_();
    }

    private void renderOnboardingTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.hasRecipeError() && this.isHoveringRedCross(mouseX, mouseY)) {
            Component tooltip = SmithingScreen.f_266014_;
            this.renderOnboardingTooltip(guiGraphics, mouseX, mouseY, tooltip);
        } else if (this.isHoveringEmptySlot(((SmithingUpgradeContainer)this.getContainer()).getTemplateSlot(), mouseX, mouseY)) {
            this.renderOnboardingTooltip(guiGraphics, mouseX, mouseY, SmithingScreen.f_266043_);
        } else {
            Item item = ((SmithingUpgradeContainer)this.getContainer()).getTemplateSlot().m_7993_().m_41720_();
            if (item instanceof SmithingTemplateItem) {
                SmithingTemplateItem smithingTemplate = (SmithingTemplateItem)item;
                if (this.isHoveringEmptySlot(((SmithingUpgradeContainer)this.getContainer()).getBaseSlot(), mouseX, mouseY)) {
                    this.renderOnboardingTooltip(guiGraphics, mouseX, mouseY, smithingTemplate.m_266212_());
                } else if (this.isHoveringEmptySlot(((SmithingUpgradeContainer)this.getContainer()).getAdditionalSlot(), mouseX, mouseY)) {
                    this.renderOnboardingTooltip(guiGraphics, mouseX, mouseY, smithingTemplate.m_266549_());
                }
            }
        }
    }

    private void renderOnboardingTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, Component tooltip) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 410.0f);
        guiGraphics.m_280245_(this.font, this.font.m_92923_((FormattedText)tooltip, 115), mouseX, mouseY);
        guiGraphics.m_280168_().m_85849_();
    }

    private boolean hasRecipeError() {
        return ((SmithingUpgradeContainer)this.getContainer()).getTemplateSlot().m_6657_() && ((SmithingUpgradeContainer)this.getContainer()).getBaseSlot().m_6657_() && ((SmithingUpgradeContainer)this.getContainer()).getAdditionalSlot().m_6657_() && !((SmithingUpgradeContainer)this.getContainer()).getResultSlot().m_6657_();
    }
}

