/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.rsinsertexportupgrade.network;

import com.ultramega.rsinsertexportupgrade.container.UpgradeContainerMenu;
import com.ultramega.rsinsertexportupgrade.item.UpgradeItem;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class UpgradeUpdateMessage {
    private final int type;
    private final int compare;
    private final int mode;
    private final int[] selectedInventorySlots;
    private final int selectedSideButton;

    public UpgradeUpdateMessage(int type, int compare, int mode, int[] selectedInventorySlots, int selectedSideButton) {
        this.type = type;
        this.compare = compare;
        this.mode = mode;
        this.selectedInventorySlots = selectedInventorySlots;
        this.selectedSideButton = selectedSideButton;
    }

    public static UpgradeUpdateMessage decode(FriendlyByteBuf buf) {
        return new UpgradeUpdateMessage(buf.readInt(), buf.readInt(), buf.readInt(), buf.m_130100_(), buf.readInt());
    }

    public static void encode(UpgradeUpdateMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.type);
        buf.writeInt(message.compare);
        buf.writeInt(message.mode);
        buf.m_130089_(message.selectedInventorySlots);
        buf.writeInt(message.selectedSideButton);
    }

    public static void handle(UpgradeUpdateMessage message, Supplier<NetworkEvent.Context> ctx) {
        AbstractContainerMenu abstractContainerMenu;
        ServerPlayer player = ctx.get().getSender();
        if (player != null && (abstractContainerMenu = player.f_36096_) instanceof UpgradeContainerMenu) {
            UpgradeContainerMenu containerMenu = (UpgradeContainerMenu)abstractContainerMenu;
            ctx.get().enqueueWork(() -> {
                UpgradeItem.setCompare(containerMenu.getGridItem(), message.compare, message.selectedSideButton);
                UpgradeItem.setSelectedInventorySlots(containerMenu.getGridItem(), message.selectedInventorySlots, message.selectedSideButton);
                UpgradeItem.setMode(containerMenu.getGridItem(), message.mode, message.selectedSideButton);
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

