/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.travel;

import com.enderio.EnderIO;
import com.enderio.api.travel.ITravelTarget;
import com.enderio.base.common.config.BaseConfig;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.ForgeRegistries;

public class AnchorTravelTarget
implements ITravelTarget {
    public static final ResourceLocation SERIALIZED_NAME = EnderIO.loc("travel_anchor");
    private final BlockPos pos;
    private String name;
    private Item icon;
    private boolean visible;

    public AnchorTravelTarget(BlockPos pos, String name, Item icon, boolean visible) {
        this.pos = pos;
        this.name = name;
        this.icon = icon;
        this.visible = visible;
    }

    public AnchorTravelTarget(CompoundTag tag) {
        this.pos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("BlockPos"));
        this.name = tag.m_128461_("AnchorName");
        String iconName = tag.m_128461_("AnchorIcon");
        this.icon = iconName.equals("") ? Items.f_41852_ : (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(iconName));
        this.visible = tag.m_128471_("AnchorVisibility");
    }

    @Override
    public CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("BlockPos", (Tag)NbtUtils.m_129224_((BlockPos)this.pos));
        nbt.m_128359_("AnchorName", this.name);
        nbt.m_128359_("AnchorIcon", String.valueOf(ForgeRegistries.ITEMS.getKey((Object)this.icon)));
        nbt.m_128379_("AnchorVisibility", this.visible);
        return nbt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnchorTravelTarget)) {
            return false;
        }
        AnchorTravelTarget other = (AnchorTravelTarget)o;
        return this.pos.equals((Object)other.pos) && this.name.equals(other.name) && this.visible == other.visible && Objects.equals(this.icon, other.icon);
    }

    public int hashCode() {
        return Objects.hash(this.pos, this.name, this.icon);
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Item getIcon() {
        return this.icon;
    }

    public void setIcon(Item icon) {
        this.icon = icon;
    }

    public boolean getVisibility() {
        return this.visible;
    }

    public void setVisibility(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean canTravelTo() {
        return this.getVisibility();
    }

    @Override
    public boolean canTeleportTo() {
        return this.getVisibility();
    }

    @Override
    public boolean canJumpTo() {
        return true;
    }

    @Override
    public int getItem2BlockRange() {
        return (Integer)BaseConfig.COMMON.ITEMS.TRAVELLING_TO_BLOCK_RANGE.get();
    }

    @Override
    public int getBlock2BlockRange() {
        return (Integer)BaseConfig.COMMON.ITEMS.TRAVELLING_BLOCK_TO_BLOCK_RANGE.get();
    }

    @Override
    public ResourceLocation getSerializationName() {
        return SERIALIZED_NAME;
    }
}

