/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity;

import com.enderio.api.capacitor.CapacitorModifier;
import com.enderio.api.capacitor.QuadraticScalable;
import com.enderio.api.io.energy.EnergyIOMode;
import com.enderio.core.common.network.slot.FloatNetworkDataSlot;
import com.enderio.machines.common.blockentity.base.PoweredMachineBlockEntity;
import com.enderio.machines.common.config.MachinesConfig;
import com.enderio.machines.common.io.item.MachineInventoryLayout;
import com.enderio.machines.common.io.item.SingleSlotAccess;
import com.enderio.machines.common.menu.WiredChargerMenu;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class WiredChargerBlockEntity
extends PoweredMachineBlockEntity {
    public static final QuadraticScalable CAPACITY = new QuadraticScalable(CapacitorModifier.ENERGY_CAPACITY, (Supplier<Integer>)MachinesConfig.COMMON.ENERGY.WIRED_CHARGER_CAPACITY);
    public static final QuadraticScalable USAGE = new QuadraticScalable(CapacitorModifier.ENERGY_USE, (Supplier<Integer>)MachinesConfig.COMMON.ENERGY.WIRED_CHARGER_USAGE);
    public static final SingleSlotAccess ITEM_TO_CHARGE = new SingleSlotAccess();
    public static final SingleSlotAccess ITEM_CHARGED = new SingleSlotAccess();
    private float progress = 0.0f;

    public WiredChargerBlockEntity(BlockEntityType<?> type, BlockPos worldPosition, BlockState blockState) {
        super(EnergyIOMode.Input, CAPACITY, USAGE, type, worldPosition, blockState);
        this.addDataSlot(new FloatNetworkDataSlot(this::getProgress, p -> {
            this.progress = p.floatValue();
        }));
    }

    @Override
    public MachineInventoryLayout createInventoryLayout() {
        return MachineInventoryLayout.builder().capacitor().inputSlot((slot, stack) -> this.acceptItem((ItemStack)stack)).slotAccess(ITEM_TO_CHARGE).outputSlot().slotAccess(ITEM_CHARGED).build();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new WiredChargerMenu(this, pPlayerInventory, pContainerId);
    }

    @Override
    public void serverTick() {
        super.serverTick();
        if (this.canAct()) {
            this.chargeItem();
        } else {
            this.progress = 0.0f;
        }
    }

    @Override
    protected boolean isActive() {
        return this.canAct();
    }

    public boolean acceptItem(ItemStack item) {
        Optional energyHandlerCap = item.getCapability(ForgeCapabilities.ENERGY).resolve();
        return energyHandlerCap.isPresent();
    }

    @Override
    public boolean canAct() {
        ItemStack inputItem = ITEM_TO_CHARGE.getItemStack(this);
        ItemStack outputItem = ITEM_CHARGED.getItemStack(this);
        return !inputItem.m_41619_() && outputItem.m_41619_() && this.acceptItem(inputItem) && super.canAct();
    }

    public void chargeItem() {
        ItemStack chargeable = ITEM_TO_CHARGE.getItemStack(this);
        Optional energyHandlerCap = chargeable.getCapability(ForgeCapabilities.ENERGY).resolve();
        if (energyHandlerCap.isPresent()) {
            IEnergyStorage itemEnergyStorage = (IEnergyStorage)energyHandlerCap.get();
            if (itemEnergyStorage.getEnergyStored() == itemEnergyStorage.getMaxEnergyStored()) {
                ITEM_CHARGED.setStackInSlot(this, chargeable);
                ITEM_TO_CHARGE.setStackInSlot(this, ItemStack.f_41583_);
            } else {
                int energyToInsert = Math.min(itemEnergyStorage.getMaxEnergyStored() - itemEnergyStorage.getEnergyStored(), Math.max(this.energyStorage.getEnergyStored(), this.energyStorage.getMaxEnergyUse()));
                if (energyToInsert > 0) {
                    itemEnergyStorage.receiveEnergy(energyToInsert, false);
                    this.energyStorage.takeEnergy(energyToInsert);
                    this.progress = (float)itemEnergyStorage.getEnergyStored() / (float)itemEnergyStorage.getMaxEnergyStored();
                }
            }
        }
    }

    public float getProgress() {
        return this.progress;
    }
}

