/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.block.glass;

import com.enderio.EnderIO;
import com.enderio.base.common.block.glass.FusedQuartzBlock;
import com.enderio.base.common.block.glass.GlassIdentifier;
import com.enderio.base.common.block.glass.GlassLighting;
import com.enderio.base.common.init.EIOCreativeTabs;
import com.enderio.base.common.tag.EIOTags;
import com.google.common.collect.ImmutableMap;
import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.generators.ModelFile;

public class GlassBlocks {
    public final BlockEntry<FusedQuartzBlock> CLEAR;
    public final Map<DyeColor, BlockEntry<FusedQuartzBlock>> COLORS;
    private final GlassIdentifier glassIdentifier;

    public GlassBlocks(Registrate registrate, GlassIdentifier identifier) {
        this.glassIdentifier = identifier;
        String name = identifier.glassName();
        this.CLEAR = this.register(registrate, name);
        HashMap<DyeColor, BlockEntry<FusedQuartzBlock>> tempMap = new HashMap<DyeColor, BlockEntry<FusedQuartzBlock>>();
        for (DyeColor color : DyeColor.values()) {
            tempMap.put(color, this.register(registrate, name.concat("_").concat(color.m_41065_()), color));
        }
        this.COLORS = ImmutableMap.copyOf(tempMap);
    }

    public Stream<BlockEntry<FusedQuartzBlock>> getAllBlocks() {
        return Stream.concat(Stream.of(this.CLEAR), this.COLORS.values().stream());
    }

    private ResourceLocation getModelFile() {
        return this.glassIdentifier.explosion_resistance() ? EnderIO.loc("block/fused_quartz") : EnderIO.loc("block/clear_glass");
    }

    private static boolean never(BlockState p_50806_, BlockGetter p_50807_, BlockPos p_50808_) {
        return false;
    }

    private static boolean never(BlockState p_50779_, BlockGetter p_50780_, BlockPos p_50781_, EntityType<?> p_50782_) {
        return false;
    }

    private BlockEntry<FusedQuartzBlock> register(Registrate registrate, String name) {
        ItemBuilder builder = ((BlockBuilder)registrate.block(name, props -> new FusedQuartzBlock((BlockBehaviour.Properties)props, this.glassIdentifier, null)).tag(new TagKey[]{this.glassIdentifier.explosion_resistance() ? EIOTags.Blocks.FUSED_QUARTZ : EIOTags.Blocks.CLEAR_GLASS}).setData(ProviderType.LANG, NonNullBiConsumer.noop())).blockstate((con, prov) -> prov.simpleBlock((Block)con.get(), (ModelFile)prov.models().getExistingFile(this.getModelFile()))).properties(props -> props.m_60955_().m_60978_(0.3f).m_60918_(SoundType.f_56744_).m_60955_().m_60922_(GlassBlocks::never).m_60924_(GlassBlocks::never).m_60960_(GlassBlocks::never).m_60971_(GlassBlocks::never)).item().tab(EIOCreativeTabs.BLOCKS).tag(new TagKey[]{this.glassIdentifier.explosion_resistance() ? EIOTags.Items.FUSED_QUARTZ : EIOTags.Items.CLEAR_GLASS}).tag(new TagKey[]{EIOTags.Items.GLASS_TAGS.get(this.glassIdentifier)});
        if (this.glassIdentifier.lighting() == GlassLighting.EMITTING && this.glassIdentifier.explosion_resistance()) {
            builder.tag(new TagKey[]{EIOTags.Items.ENLIGHTENED_FUSED_QUARTZ});
        }
        if (this.glassIdentifier.lighting() == GlassLighting.BLOCKING && this.glassIdentifier.explosion_resistance()) {
            builder.tag(new TagKey[]{EIOTags.Items.DARK_FUSED_QUARTZ});
        }
        return ((BlockBuilder)builder.build()).register();
    }

    private BlockEntry<FusedQuartzBlock> register(Registrate registrate, String name, DyeColor color) {
        return ((BlockBuilder)((BlockBuilder)registrate.block(name, props -> new FusedQuartzBlock((BlockBehaviour.Properties)props, this.glassIdentifier, color)).setData(ProviderType.LANG, NonNullBiConsumer.noop())).blockstate((con, prov) -> prov.simpleBlock((Block)con.get(), (ModelFile)prov.models().getExistingFile(this.getModelFile()))).color(() -> () -> (p_92567_, p_92568_, p_92569_, p_92570_) -> color.m_284406_().f_283871_).properties(props -> props.m_60955_().m_60978_(0.3f).m_60918_(SoundType.f_56744_).m_60955_().m_60922_(GlassBlocks::never).m_60924_(GlassBlocks::never).m_60960_(GlassBlocks::never).m_60971_(GlassBlocks::never).m_284268_(color)).item().tab(EIOCreativeTabs.BLOCKS).tag(new TagKey[]{EIOTags.Items.GLASS_TAGS.get(this.glassIdentifier)}).color(() -> () -> (p_92672_, p_92673_) -> color.m_284406_().f_283871_).build()).register();
    }

    public GlassIdentifier getGlassIdentifier() {
        return this.glassIdentifier;
    }
}

