/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Supplier;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.core.ModBlockEntities;
import me.desht.modularrouters.util.BeamData;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.network.NetworkEvent;

public class ItemBeamMessage {
    private final BlockPos pos1;
    private final List<BeamData> beams;

    public ItemBeamMessage(BlockEntity te, List<BeamData> beams) {
        this.pos1 = te.m_58899_();
        this.beams = beams;
    }

    public ItemBeamMessage(FriendlyByteBuf buf) {
        this.pos1 = buf.m_130135_();
        ImmutableList.Builder builder = ImmutableList.builder();
        int n = buf.m_130242_();
        for (int i = 0; i < n; ++i) {
            builder.add((Object)new BeamData(buf, this.pos1));
        }
        this.beams = builder.build();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos1);
        buf.m_130130_(this.beams.size());
        this.beams.forEach(beam -> beam.toBytes(buf, this.pos1));
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientUtil.theClientWorld().m_141902_(this.pos1, (BlockEntityType)ModBlockEntities.MODULAR_ROUTER.get()).ifPresent(te -> this.beams.forEach(te::addItemBeam)));
        ctx.get().setPacketHandled(true);
    }
}

