/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import net.minecraft.CrashReport;
import net.minecraft.FileUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ErrorScreen;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.GeneralConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class GuiMainMenuExtensionDevWorld {
    private static final String WORLD_NAME_PREFIX = "cyclops-dev";

    @SubscribeEvent
    public static void onMainMenuInit(ScreenEvent.Init event) {
        if (GeneralConfig.devWorldButton && event.getScreen() instanceof TitleScreen) {
            Button buttonBuilt = Button.m_253074_((Component)Component.m_237115_((String)"general.cyclopscore.dev_world"), button -> {
                String saveName;
                Minecraft mc = Minecraft.m_91087_();
                if (!MinecraftHelpers.isShifted()) {
                    LevelSummary devWorldSummary = null;
                    mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                    try {
                        List levelList = (List)((CompletableFuture)mc.m_91392_().m_230813_(mc.m_91392_().m_230833_()).exceptionally(p_233202_ -> {
                            mc.m_231412_(CrashReport.m_127521_((Throwable)p_233202_, (String)"Couldn't load level list"));
                            return List.of();
                        })).get(5000L, TimeUnit.MILLISECONDS);
                        for (LevelSummary worldSummary : levelList) {
                            if (!worldSummary.m_78361_().equals(WORLD_NAME_PREFIX) || devWorldSummary != null && devWorldSummary.m_78366_() >= worldSummary.m_78366_()) continue;
                            devWorldSummary = worldSummary;
                        }
                    }
                    catch (InterruptedException | ExecutionException | TimeoutException | LevelStorageException e) {
                        CyclopsCore.clog(Level.ERROR, "Couldn't load level list" + e.getMessage());
                        mc.m_91152_((Screen)new ErrorScreen((Component)Component.m_237115_((String)"selectWorld.unable_to_load"), (Component)Component.m_237113_((String)e.getMessage())));
                    }
                    if (devWorldSummary != null && mc.m_91392_().m_78255_(devWorldSummary.m_78358_())) {
                        mc.m_91346_((Screen)new GenericDirtMessageScreen((Component)Component.m_237115_((String)"selectWorld.data_read")));
                        mc.m_231466_().m_233133_(event.getScreen(), devWorldSummary.m_78358_());
                        return;
                    }
                }
                GameRules gameRules = new GameRules();
                ((GameRules.BooleanValue)gameRules.m_46170_(GameRules.f_46140_)).m_46246_(false, null);
                ((GameRules.BooleanValue)gameRules.m_46170_(GameRules.f_46156_)).m_46246_(true, null);
                ((GameRules.BooleanValue)gameRules.m_46170_(GameRules.f_46124_)).m_46246_(false, null);
                ((GameRules.BooleanValue)gameRules.m_46170_(GameRules.f_46125_)).m_46246_(false, null);
                WorldDataConfiguration worlddataconfiguration = new WorldDataConfiguration(new DataPackConfig(new ArrayList(Minecraft.m_91087_().m_91099_().m_10514_()), List.of()), FeatureFlags.f_244280_.m_247355_());
                LevelSettings worldsettings = new LevelSettings(WORLD_NAME_PREFIX, GameType.CREATIVE, false, Difficulty.PEACEFUL, true, gameRules, worlddataconfiguration);
                Function<RegistryAccess, WorldDimensions> generatorSettings = registryAccess -> ((WorldPreset)registryAccess.m_175515_(Registries.f_256729_).m_246971_(WorldPresets.f_226438_).m_203334_()).m_247748_();
                long seed = new Random().nextLong();
                WorldOptions worldOptions = new WorldOptions(seed, false, false);
                try {
                    saveName = FileUtil.m_133730_((Path)mc.m_91392_().m_78257_(), (String)WORLD_NAME_PREFIX, (String)"");
                }
                catch (IOException e) {
                    saveName = "World";
                }
                mc.m_231466_().m_233157_(saveName, worldsettings, worldOptions, generatorSettings);
            }).m_252794_(event.getScreen().f_96543_ / 2 + 102, event.getScreen().f_96544_ / 4 + 48).m_253046_(58, 20).m_253136_();
            event.addListener((GuiEventListener)buttonBuilt);
        }
    }
}

