/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.api.network;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageSlotted;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageWrapperHandler;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientComponentStorageObservable;
import org.cyclops.integrateddynamics.api.network.INetworkIngredientsChannel;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetwork;
import org.cyclops.integrateddynamics.api.network.PositionedAddonsNetworkIngredientsFilter;
import org.cyclops.integrateddynamics.api.part.PartPos;

public interface IPositionedAddonsNetworkIngredients<T, M>
extends IPositionedAddonsNetwork,
IIngredientComponentStorageObservable<T, M> {
    @Override
    public IngredientComponent<T, M> getComponent();

    public long getRateLimit();

    public IIngredientComponentStorage<T, M> getPositionedStorage(PartPos var1);

    public void setPositionedStorageFilter(PartPos var1, @Nullable PositionedAddonsNetworkIngredientsFilter<T> var2);

    @Nullable
    public PositionedAddonsNetworkIngredientsFilter<T> getPositionedStorageFilter(PartPos var1);

    default public Iterator<T> getRawInstances(PartPos pos) {
        Iterator it = this.getPositionedStorage(pos).iterator();
        PositionedAddonsNetworkIngredientsFilter<T> filter = this.getPositionedStorageFilter(pos);
        if (filter != null) {
            it = Iterators.filter((Iterator)it, filter::testView);
        }
        return it;
    }

    @Nullable
    default public IIngredientComponentStorage<T, M> getPositionedStorageUnsafe(PartPos pos) {
        DimPos dimPos = pos.getPos();
        Level world = dimPos.getLevel(true);
        if (world == null) {
            return null;
        }
        Optional tile = BlockEntityHelpers.get((BlockGetter)world, (BlockPos)dimPos.getBlockPos(), BlockEntity.class);
        return tile.map(tileEntity -> this.getComponent().getStorage((ICapabilityProvider)tileEntity, pos.getSide())).orElse(null);
    }

    public INetworkIngredientsChannel<T, M> getChannelInternal(int var1);

    @Deprecated
    default public IIngredientComponentStorage<T, M> getChannel(int channel) {
        return this.getChannelInternal(channel);
    }

    public IIngredientComponentStorageSlotted<T, M> getChannelSlotted(int var1);

    @Nullable
    default public <S> S getChannelExternal(Capability<S> capability, int channel) {
        IIngredientComponentStorageWrapperHandler wrapperHandler = this.getComponent().getStorageWrapperHandler(capability);
        return (S)(wrapperHandler != null ? wrapperHandler.wrapStorage(this.getChannel(channel)) : null);
    }

    public Map<PartPos, Long> getLastSecondDurationIndex();

    public void resetLastSecondDurationsIndex();
}

