/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.cables.client;

import javax.annotation.Nonnull;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.VerticalAlignment;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.network.Networking;
import mcjty.lib.network.PacketRequestDataFromServer;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.OrientationTools;
import mcjty.xnet.modules.cables.CableModule;
import mcjty.xnet.modules.cables.ConnectorType;
import mcjty.xnet.modules.cables.blocks.ConnectorBlock;
import mcjty.xnet.modules.cables.blocks.ConnectorTileEntity;
import mcjty.xnet.utils.I18nConstants;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class GuiConnector
extends GenericGuiContainer<ConnectorTileEntity, GenericContainer> {
    public static final int WIDTH = 230;
    public static final int HEIGHT = 60;
    private final ToggleButton[] toggleButtons = new ToggleButton[6];
    private final BlockRender[] connectedBlockRenders = new BlockRender[6];

    public GuiConnector(ConnectorTileEntity tileEntity, GenericContainer container, Inventory inventory) {
        super((GenericTileEntity)tileEntity, (AbstractContainerMenu)container, inventory, ((ConnectorBlock)CableModule.CONNECTOR.get()).getManualEntry());
        Level level = tileEntity.m_58904_();
        if (level == null) {
            return;
        }
        Networking.sendToServer((Object)new PacketRequestDataFromServer(level.m_46472_(), tileEntity.m_58899_(), ConnectorTileEntity.CMD_GET_NAME.name(), TypedMap.EMPTY, false));
        this.f_97726_ = 230;
        this.f_97727_ = 60;
    }

    public static void register() {
        GuiConnector.register(CableModule.CONTAINER_CONNECTOR.get(), GuiConnector::new);
    }

    public void m_7856_() {
        super.m_7856_();
        Panel toplevel = (Panel)Widgets.vertical().filledRectThickness(2);
        Level level = ((ConnectorTileEntity)this.tileEntity).m_58904_();
        if (level == null) {
            return;
        }
        BlockEntity te = level.m_7702_(((ConnectorTileEntity)this.tileEntity).m_58899_());
        if (te instanceof ConnectorTileEntity) {
            ((ConnectorTileEntity)this.tileEntity).setConnectorName(((ConnectorTileEntity)te).getConnectorName());
        }
        String connectorName = ((ConnectorTileEntity)this.tileEntity).getConnectorName();
        TextField nameField = (TextField)((TextField)new TextField().name("name")).tooltips(new String[]{I18nConstants.CONNECTOR_NAME_TOOLTIP.i18n(new Object[0])});
        if (connectorName != null && !connectorName.isEmpty()) {
            nameField.text(((ConnectorTileEntity)this.tileEntity).getConnectorName());
        }
        Label nameLabel = (Label)((Label)Widgets.label((String)I18nConstants.NAME_LABEL.i18n(new Object[0])).verticalAlignment(VerticalAlignment.ALIGN_CENTER)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
        Panel namePanel = (Panel)((Panel)Widgets.horizontal().children(new Widget[]{nameLabel, nameField})).desiredHeight(20);
        toplevel.children(new Widget[]{namePanel});
        Label directionsLabel = (Label)((Label)Widgets.label((String)I18nConstants.DIRECTIONS_LABEL.i18n(new Object[0])).desiredWidth(70)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
        Panel directionsPanel = (Panel)Widgets.horizontal().children(new Widget[]{directionsLabel});
        Panel directionValuesPanel = Widgets.vertical();
        Panel directionNamesPanel = Widgets.horizontal((int)6, (int)5);
        Panel directionBlocksPanel = Widgets.horizontal();
        for (Direction facing : OrientationTools.DIRECTION_VALUES) {
            BlockPos consumerPos = ((ConnectorTileEntity)this.tileEntity).m_58899_().m_121945_(facing);
            BlockState state = level.m_8055_(consumerPos);
            ItemStack item = state.m_60734_().m_7397_((BlockGetter)level, consumerPos, state);
            this.connectedBlockRenders[facing.ordinal()] = (BlockRender)new BlockRender().renderItem((Object)item).userObject((Object)"block");
            this.toggleButtons[facing.ordinal()] = ((ToggleButton)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().text(facing.m_7912_().substring(0, 1).toUpperCase())).desiredWidth(16)).verticalAlignment(VerticalAlignment.ALIGN_CENTER)).horizontalAlignment(HorizontalAlignment.ALIGN_CENTER)).event(() -> this.sendServerCommandTyped(ConnectorTileEntity.CMD_ENABLE, TypedMap.builder().put(ConnectorTileEntity.PARAM_FACING, (Object)facing.ordinal()).put(ConnectorTileEntity.PARAM_ENABLED, (Object)this.toggleButtons[facing.ordinal()].isPressed()).build()));
            boolean isEnabled = !((ConnectorType)((Object)((ConnectorTileEntity)this.tileEntity).m_58900_().m_61143_((Property)EnumProperty.m_61587_((String)facing.m_122433_(), ConnectorType.class)))).equals((Object)ConnectorType.NONE);
            this.toggleButtons[facing.ordinal()].pressed(isEnabled);
            directionNamesPanel.children(new Widget[]{this.toggleButtons[facing.ordinal()]});
        }
        directionBlocksPanel.children((Widget[])this.connectedBlockRenders);
        directionValuesPanel.children(new Widget[]{directionBlocksPanel, directionNamesPanel});
        directionsPanel.children(new Widget[]{directionValuesPanel});
        toplevel.children(new Widget[]{directionsPanel});
        toplevel.bounds(this.f_97735_, this.f_97736_, 230, 60);
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
        this.window.bind("name", (GenericTileEntity)((ConnectorTileEntity)this.tileEntity), "name");
    }

    protected void m_7286_(@Nonnull GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        this.drawWindow(graphics);
    }
}

