/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.client;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.lib.blockcommands.ISerializer;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.api.xnet.channels.IChannelSettings;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.rftoolsbase.api.xnet.keys.ConsumerId;
import mcjty.rftoolsbase.api.xnet.keys.SidedConsumer;
import mcjty.xnet.XNet;
import mcjty.xnet.client.ConnectorClientInfo;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public class ChannelClientInfo {
    @Nonnull
    private final IChannelType type;
    @Nonnull
    private final IChannelSettings channelSettings;
    @Nonnull
    private final String channelName;
    private final boolean enabled;
    private final Map<SidedConsumer, ConnectorClientInfo> connectors = new HashMap<SidedConsumer, ConnectorClientInfo>();

    public ChannelClientInfo(@Nonnull String channelName, @Nonnull IChannelType type, @Nonnull IChannelSettings channelSettings, boolean enabled) {
        this.channelName = channelName;
        this.type = type;
        this.channelSettings = channelSettings;
        this.enabled = enabled;
    }

    public ChannelClientInfo(@Nonnull FriendlyByteBuf buf) {
        this.channelName = NetworkTools.readStringUTF8((FriendlyByteBuf)buf);
        this.enabled = buf.readBoolean();
        String id = buf.m_130136_(Short.MAX_VALUE);
        IChannelType t = XNet.xNetApi.findType(id);
        if (t == null) {
            throw new RuntimeException("Bad type: " + id);
        }
        this.type = t;
        this.channelSettings = this.type.createChannel();
        CompoundTag tag = buf.m_130260_();
        this.channelSettings.readFromNBT(tag);
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            SidedConsumer key = new SidedConsumer(new ConsumerId(buf.readInt()), OrientationTools.DIRECTION_VALUES[buf.readByte()]);
            ConnectorClientInfo info = new ConnectorClientInfo(buf);
            this.connectors.put(key, info);
        }
    }

    public void writeToNBT(@Nonnull FriendlyByteBuf buf) {
        NetworkTools.writeStringUTF8((FriendlyByteBuf)buf, (String)this.channelName);
        buf.writeBoolean(this.enabled);
        buf.m_130070_(this.type.getID());
        CompoundTag tag = new CompoundTag();
        this.channelSettings.writeToNBT(tag);
        buf.m_130079_(tag);
        buf.writeInt(this.connectors.size());
        for (Map.Entry<SidedConsumer, ConnectorClientInfo> entry : this.connectors.entrySet()) {
            SidedConsumer key = entry.getKey();
            ConnectorClientInfo info = entry.getValue();
            buf.writeInt(key.consumerId().id());
            buf.writeByte(key.side().ordinal());
            info.writeToBuf(buf);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Nonnull
    public String getChannelName() {
        return this.channelName;
    }

    @Nonnull
    public IChannelType getType() {
        return this.type;
    }

    @Nonnull
    public IChannelSettings getChannelSettings() {
        return this.channelSettings;
    }

    @Nonnull
    public Map<SidedConsumer, ConnectorClientInfo> getConnectors() {
        return this.connectors;
    }

    public static class Serializer
    implements ISerializer<ChannelClientInfo> {
        public Function<FriendlyByteBuf, ChannelClientInfo> getDeserializer() {
            return buf -> {
                if (buf.readBoolean()) {
                    return new ChannelClientInfo((FriendlyByteBuf)buf);
                }
                return null;
            };
        }

        public BiConsumer<FriendlyByteBuf, ChannelClientInfo> getSerializer() {
            return (buf, info) -> {
                if (info == null) {
                    buf.writeBoolean(false);
                } else {
                    buf.writeBoolean(true);
                    info.writeToNBT((FriendlyByteBuf)buf);
                }
            };
        }
    }
}

