/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.items;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.gui.ITranslatableEnum;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.xnet.channels.IChannelSettings;
import mcjty.rftoolsbase.api.xnet.channels.IConnectorSettings;
import mcjty.rftoolsbase.api.xnet.channels.IControllerContext;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mcjty.rftoolsbase.api.xnet.helper.DefaultChannelSettings;
import mcjty.rftoolsbase.api.xnet.keys.ConsumerId;
import mcjty.rftoolsbase.api.xnet.keys.SidedConsumer;
import mcjty.xnet.apiimpl.ConnectedEntity;
import mcjty.xnet.apiimpl.EnumStringTranslators;
import mcjty.xnet.apiimpl.enums.ChannelMode;
import mcjty.xnet.apiimpl.enums.InsExtMode;
import mcjty.xnet.apiimpl.items.ItemConnectorSettings;
import mcjty.xnet.apiimpl.items.enums.StackMode;
import mcjty.xnet.compat.RFToolsSupport;
import mcjty.xnet.modules.cables.blocks.ConnectorTileEntity;
import mcjty.xnet.setup.Config;
import mcjty.xnet.utils.CastTools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemChannelSettings
extends DefaultChannelSettings
implements IChannelSettings {
    public static final ResourceLocation iconGuiElements = new ResourceLocation("xnet", "textures/gui/guielements.png");
    private List<ConnectedEntity<ItemConnectorSettings>> itemExtractors = null;
    private List<ConnectedEntity<ItemConnectorSettings>> itemConsumers = null;
    private boolean[] consumerFull;
    private ChannelMode channelMode = ChannelMode.PRIORITY;
    private int delay = 0;
    private int roundRobinOffset = 0;
    private final Map<ConsumerId, Integer> extractIndices = new HashMap<ConsumerId, Integer>();
    private static final Random random = new Random();

    public ChannelMode getChannelMode() {
        return this.channelMode;
    }

    public int getColors() {
        return 0;
    }

    public JsonObject writeToJson() {
        JsonObject object = new JsonObject();
        object.add("mode", (JsonElement)new JsonPrimitive(this.channelMode.name()));
        return object;
    }

    public void readFromJson(JsonObject data) {
        this.channelMode = EnumStringTranslators.getItemChannelMode(data.get("mode").getAsString());
    }

    public void readFromNBT(CompoundTag tag) {
        this.channelMode = ChannelMode.values()[tag.m_128445_("mode")];
        this.delay = tag.m_128451_("delay");
        this.roundRobinOffset = tag.m_128451_("offset");
        int[] cons = tag.m_128465_("extidx");
        for (int idx = 0; idx < cons.length; idx += 2) {
            this.extractIndices.put(new ConsumerId(cons[idx]), cons[idx + 1]);
        }
    }

    public void writeToNBT(CompoundTag tag) {
        tag.m_128344_("mode", (byte)this.channelMode.ordinal());
        tag.m_128405_("delay", this.delay);
        tag.m_128405_("offset", this.roundRobinOffset);
        if (!this.extractIndices.isEmpty()) {
            int[] cons = new int[this.extractIndices.size() * 2];
            int idx = 0;
            for (Map.Entry<ConsumerId, Integer> entry : this.extractIndices.entrySet()) {
                cons[idx++] = entry.getKey().id();
                cons[idx++] = entry.getValue();
            }
            tag.m_128385_("extidx", cons);
        }
    }

    private int getExtractIndex(ConsumerId consumer) {
        return this.extractIndices.getOrDefault(consumer, 0);
    }

    private void rememberExtractIndex(ConsumerId consumer, int index) {
        this.extractIndices.put(consumer, index);
    }

    public void tick(int channel, IControllerContext context) {
        --this.delay;
        if (this.delay <= 0) {
            this.delay = 1200;
        }
        if (this.delay % 5 != 0) {
            return;
        }
        int d = this.delay / 5;
        this.updateCache(channel, context);
        Level world = context.getControllerWorld();
        this.consumerFull = new boolean[this.itemConsumers.size()];
        for (int i = 0; i < this.itemExtractors.size(); ++i) {
            ConnectedEntity<ItemConnectorSettings> extractor = this.itemExtractors.get(i);
            ItemConnectorSettings settings = (ItemConnectorSettings)((Object)extractor.settings());
            if (d % settings.getSpeed() != 0) continue;
            ConsumerId consumerId = extractor.sidedConsumer().consumerId();
            if (!LevelTools.isLoaded((Level)world, (BlockPos)extractor.getBlockPos()) || !this.checkRedstone(settings, extractor.getConnectorEntity(), context)) continue;
            if (RFToolsSupport.isStorageScanner(extractor.getConnectedEntity())) {
                RFToolsSupport.tickStorageScanner(context, settings, extractor.getConnectedEntity(), this, world);
                continue;
            }
            IItemHandler handler = ItemChannelSettings.getItemHandlerAt(extractor.getConnectedEntity(), ((ItemConnectorSettings)((Object)extractor.settings())).getFacing());
            if (handler == null) continue;
            int idx = this.getStartExtractIndex(settings, consumerId, handler);
            idx = this.tickItemHandler(context, settings, handler, world, idx, i);
            if (handler.getSlots() <= 0) continue;
            this.rememberExtractIndex(consumerId, (idx + 1) % handler.getSlots());
        }
    }

    private int getStartExtractIndex(ItemConnectorSettings settings, ConsumerId consumerId, IItemHandler handler) {
        switch (settings.getExtractMode()) {
            case FIRST: {
                return 0;
            }
            case RND: {
                if (handler.getSlots() <= 0) {
                    return 0;
                }
                for (int i = 0; i < 5; ++i) {
                    int idx = random.nextInt(handler.getSlots());
                    if (handler.getStackInSlot(idx).m_41619_()) continue;
                    return idx;
                }
                ArrayList<Integer> slots = new ArrayList<Integer>();
                for (int i = 0; i < handler.getSlots(); ++i) {
                    if (handler.getStackInSlot(i).m_41619_()) continue;
                    slots.add(i);
                }
                if (slots.isEmpty()) {
                    return 0;
                }
                return (Integer)slots.get(random.nextInt(slots.size()));
            }
            case ORDER: {
                return this.getExtractIndex(consumerId);
            }
        }
        return 0;
    }

    private int tickItemHandler(@Nonnull IControllerContext context, @Nonnull ItemConnectorSettings settings, @Nonnull IItemHandler handler, @Nonnull Level world, int startIdx, int extractorIdx) {
        ItemStack stack;
        Predicate<ItemStack> extractMatcher = settings.getMatcher(context);
        Integer count = settings.getCount();
        int amount = 0;
        if (count != null && (amount = this.countItems(handler, extractMatcher).intValue()) < count) {
            return startIdx;
        }
        MInteger index = new MInteger(startIdx);
        while (!(stack = this.fetchItem(handler, true, extractMatcher, settings.getStackMode(), settings.getExtractAmount(), 64, index, startIdx)).m_41619_()) {
            int toextract = stack.m_41613_();
            if (count != null) {
                int canextract = amount - count;
                if (canextract <= 0) {
                    index.inc();
                    continue;
                }
                if (canextract < toextract) {
                    toextract = canextract;
                    stack = stack.m_41777_();
                    stack.m_41764_(toextract);
                }
            }
            if (!context.checkAndConsumeRF(((Integer)Config.controllerOperationRFT.get()).intValue())) break;
            int remaining = this.insertStack(context, stack, world, extractorIdx);
            if (remaining != toextract) {
                this.fetchItem(handler, false, extractMatcher, settings.getStackMode(), settings.getExtractAmount(), toextract - remaining, index, startIdx);
                break;
            }
            index.inc();
        }
        return index.getSafe(handler.getSlots());
    }

    public int insertStack(@Nonnull IControllerContext context, @Nonnull ItemStack source, @Nonnull Level world, int extractorIdx) {
        if (this.channelMode == ChannelMode.PRIORITY) {
            this.roundRobinOffset = 0;
        }
        int total = source.m_41613_();
        int consumersSize = this.itemConsumers.size();
        int extractorsSize = this.itemExtractors.size();
        for (int j = 0; j < consumersSize; ++j) {
            Predicate<ItemStack> matcher;
            IItemHandler destination;
            int i = (j + this.roundRobinOffset) % consumersSize;
            if (this.consumerFull[i]) continue;
            ConnectedEntity<ItemConnectorSettings> consumer = this.itemConsumers.get(i);
            ItemConnectorSettings settings = (ItemConnectorSettings)((Object)consumer.settings());
            if (!LevelTools.isLoaded((Level)world, (BlockPos)consumer.getBlockPos()) || (destination = ItemChannelSettings.getItemHandlerAt(consumer.getConnectedEntity(), ((ItemConnectorSettings)((Object)consumer.settings())).getFacing())) == null || !(matcher = settings.getMatcher(context)).test(source) || !this.checkRedstone(settings, consumer.getConnectorEntity(), context)) continue;
            BlockEntity te = consumer.getConnectedEntity();
            int toinsert = total;
            Integer count = settings.getCount();
            if (count != null) {
                int amount = RFToolsSupport.isStorageScanner(te) ? RFToolsSupport.countItems(te, matcher, (int)count) : this.countItems(destination, matcher);
                int caninsert = count - amount;
                if (caninsert <= 0) continue;
                toinsert = Math.min(toinsert, caninsert);
                source = source.m_41777_();
                source.m_41764_(toinsert);
            }
            ItemStack remaining = RFToolsSupport.isStorageScanner(te) ? RFToolsSupport.insertItem(te, source, false) : ItemHandlerHelper.insertItem((IItemHandler)destination, (ItemStack)source, (boolean)false);
            int actuallyinserted = toinsert - remaining.m_41613_();
            if (count == null) {
                source = remaining;
            }
            if (actuallyinserted > 0) {
                this.roundRobinOffset = (this.roundRobinOffset + 1) % consumersSize;
                if ((total -= actuallyinserted) > 0) continue;
                return 0;
            }
            if (extractorsSize <= 2 || extractorIdx != 0 && extractorIdx != extractorsSize / 2 - 1 || !this.isFull(destination)) continue;
            this.consumerFull[i] = true;
        }
        return total;
    }

    private boolean isFull(IItemHandler itemHandler) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(i);
            if (stackInSlot.m_41613_() >= itemHandler.getSlotLimit(i) || stackInSlot.m_41613_() >= stackInSlot.m_41741_()) continue;
            return false;
        }
        return true;
    }

    private Integer countItems(IItemHandler h, Predicate<ItemStack> matcher) {
        int cnt = 0;
        for (int i = 0; i < h.getSlots(); ++i) {
            ItemStack s = h.getStackInSlot(i);
            if (s.m_41619_() || !matcher.test(s)) continue;
            cnt += s.m_41613_();
        }
        return cnt;
    }

    /*
     * Enabled aggressive block sorting
     */
    private ItemStack fetchItem(IItemHandler handler, boolean simulate, Predicate<ItemStack> matcher, StackMode stackMode, int extractAmount, int maxamount, MInteger index, int startIdx) {
        if (handler.getSlots() <= 0) {
            return ItemStack.f_41583_;
        }
        int i = index.get();
        while (i < handler.getSlots() + startIdx) {
            int j = i % handler.getSlots();
            ItemStack stack = handler.getStackInSlot(j);
            if (!stack.m_41619_()) {
                int s = switch (stackMode) {
                    default -> throw new IncompatibleClassChangeError();
                    case StackMode.SINGLE -> 1;
                    case StackMode.STACK -> stack.m_41741_();
                    case StackMode.COUNT -> extractAmount;
                };
                s = Math.min(s, maxamount);
                stack = handler.extractItem(j, s, simulate);
                if (!stack.m_41619_() && matcher.test(stack)) {
                    index.set(i);
                    return stack;
                }
            }
            ++i;
        }
        return ItemStack.f_41583_;
    }

    private void updateCache(int channel, IControllerContext context) {
        if (this.itemExtractors == null) {
            ConnectedEntity<ItemConnectorSettings> connectedEntity;
            ItemConnectorSettings con;
            this.itemExtractors = new ArrayList<ConnectedEntity<ItemConnectorSettings>>();
            this.itemConsumers = new ArrayList<ConnectedEntity<ItemConnectorSettings>>();
            Level world = context.getControllerWorld();
            Map connectors = context.getConnectors(channel);
            for (Map.Entry<SidedConsumer, IConnectorSettings> entry : connectors.entrySet()) {
                connectedEntity = this.getConnectedEntityInfo(context, entry, world, con = (ItemConnectorSettings)((Object)entry.getValue()));
                if (connectedEntity == null) continue;
                if (con.getItemMode() == InsExtMode.EXT) {
                    this.itemExtractors.add(connectedEntity);
                    continue;
                }
                this.itemConsumers.add(connectedEntity);
            }
            connectors = context.getRoutedConnectors(channel);
            for (Map.Entry<SidedConsumer, IConnectorSettings> entry : connectors.entrySet()) {
                con = (ItemConnectorSettings)((Object)entry.getValue());
                if (con.getItemMode() != InsExtMode.INS || (connectedEntity = this.getConnectedEntityInfo(context, entry, world, con)) == null) continue;
                this.itemConsumers.add(connectedEntity);
            }
            this.itemConsumers.sort((o1, o2) -> ((ItemConnectorSettings)((Object)((Object)((Object)o2.settings())))).getPriority().compareTo(((ItemConnectorSettings)((Object)((Object)((Object)o1.settings())))).getPriority()));
        }
    }

    @Nullable
    private ConnectedEntity<ItemConnectorSettings> getConnectedEntityInfo(IControllerContext context, Map.Entry<SidedConsumer, IConnectorSettings> entry, Level world, ItemConnectorSettings con) {
        BlockPos connectorPos = context.findConsumerPosition(entry.getKey().consumerId());
        if (connectorPos == null) {
            return null;
        }
        ConnectorTileEntity connectorEntity = (ConnectorTileEntity)world.m_7702_(connectorPos);
        if (connectorEntity == null) {
            return null;
        }
        BlockPos connectedBlockPos = connectorPos.m_121945_(entry.getKey().side());
        BlockEntity connectedEntity = world.m_7702_(connectedBlockPos);
        if (connectedEntity == null) {
            return null;
        }
        return new ConnectedEntity<ItemConnectorSettings>(entry.getKey(), con, connectorPos, connectedBlockPos, connectedEntity, connectorEntity);
    }

    public void cleanCache() {
        this.itemExtractors = null;
        this.itemConsumers = null;
    }

    public boolean isEnabled(String tag) {
        return true;
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return new IndicatorIcon(iconGuiElements, 0, 80, 11, 10);
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    public void createGui(IEditorGui gui) {
        gui.nl();
        gui.translatableChoices("mode", (ITranslatableEnum)this.channelMode, (ITranslatableEnum[])ChannelMode.values());
    }

    public void update(Map<String, Object> data) {
        this.channelMode = CastTools.safeChannelMode(data.get("mode"));
        this.roundRobinOffset = 0;
    }

    @Nullable
    public static IItemHandler getItemHandlerAt(@Nullable BlockEntity te, Direction intSide) {
        if (te != null) {
            return (IItemHandler)te.getCapability(ForgeCapabilities.ITEM_HANDLER, intSide).orElse(null);
        }
        return null;
    }

    private static class MInteger {
        private int i;

        public MInteger(int i) {
            this.i = i;
        }

        public int get() {
            return this.i;
        }

        public int getSafe(int bounds) {
            return bounds <= 0 ? this.i : this.i % bounds;
        }

        public void set(int i) {
            this.i = i;
        }

        public void inc() {
            ++this.i;
        }
    }
}

