/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet;

import java.util.function.Function;
import java.util.function.Supplier;
import mcjty.lib.datagen.DataGen;
import mcjty.lib.modules.IModule;
import mcjty.lib.modules.Modules;
import mcjty.xnet.apiimpl.XNetApi;
import mcjty.xnet.modules.cables.CableModule;
import mcjty.xnet.modules.controller.ControllerModule;
import mcjty.xnet.modules.facade.FacadeModule;
import mcjty.xnet.modules.facade.client.ClientSetup;
import mcjty.xnet.modules.router.RouterModule;
import mcjty.xnet.modules.various.VariousModule;
import mcjty.xnet.modules.wireless.WirelessRouterModule;
import mcjty.xnet.setup.Config;
import mcjty.xnet.setup.ModSetup;
import mcjty.xnet.setup.Registration;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod(value="xnet")
public class XNet {
    public static final String MODID = "xnet";
    public static final ModSetup setup = new ModSetup();
    public static XNet instance;
    private final Modules modules = new Modules();
    public static final XNetApi xNetApi;

    public XNet() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        Dist dist = FMLEnvironment.dist;
        instance = this;
        this.setupModules(bus, dist);
        Config.register(this.modules);
        Registration.register(bus);
        bus.addListener(setup::init);
        bus.addListener(arg_0 -> ((Modules)this.modules).init(arg_0));
        bus.addListener(this::processIMC);
        bus.addListener(this::onDataGen);
        if (dist.isClient()) {
            bus.addListener(arg_0 -> ((Modules)this.modules).initClient(arg_0));
            bus.addListener(ClientSetup::registerBlockColor);
        }
    }

    public static <T extends Item> Supplier<T> tab(Supplier<T> supplier) {
        return setup.tab(supplier);
    }

    private void onDataGen(GatherDataEvent event) {
        DataGen datagen = new DataGen(MODID, event);
        this.modules.datagen(datagen);
        datagen.generate();
    }

    private void setupModules(IEventBus bus, Dist dist) {
        this.modules.register((IModule)new CableModule(bus, dist));
        this.modules.register((IModule)new ControllerModule());
        this.modules.register((IModule)new FacadeModule());
        this.modules.register((IModule)new RouterModule());
        this.modules.register((IModule)new WirelessRouterModule());
        this.modules.register((IModule)new VariousModule());
    }

    private void processIMC(InterModProcessEvent event) {
        event.getIMCStream().forEach(message -> {
            if ("getXNet".equalsIgnoreCase(message.method())) {
                Supplier supplier = message.getMessageSupplier();
                ((Function)supplier.get()).apply(xNetApi);
            }
        });
    }

    static {
        xNetApi = new XNetApi();
    }
}

