/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.crafttweaker;

import com.blakebr0.extendedcrafting.api.crafting.IFluxCrafterRecipe;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapedFluxCrafterRecipe;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapelessFluxCrafterRecipe;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.action.recipe.ActionRemoveRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.extendedcrafting.FluxCrafting")
@ZenRegister
public final class FluxCrafting
implements IRecipeManager<IFluxCrafterRecipe> {
    private static final FluxCrafting INSTANCE = new FluxCrafting();

    public RecipeType<IFluxCrafterRecipe> getRecipeType() {
        return (RecipeType)ModRecipeTypes.FLUX_CRAFTER.get();
    }

    @ZenCodeType.Method
    public static void addShaped(String name, IItemStack output, IIngredient[][] inputs, int powerRequired) {
        FluxCrafting.addShaped(name, output, inputs, powerRequired, (Integer)ModConfigs.FLUX_CRAFTER_POWER_RATE.get());
    }

    @ZenCodeType.Method
    public static void addShaped(String name, IItemStack output, IIngredient[][] inputs, int powerRequired, int powerRate) {
        ResourceLocation id = CraftTweakerConstants.rl((String)INSTANCE.fixRecipeName(name));
        int height = inputs.length;
        int width = 0;
        for (IIngredient[] row : inputs) {
            if (width >= row.length) continue;
            width = row.length;
        }
        NonNullList ingredients = NonNullList.m_122780_((int)(height * width), (Object)Ingredient.f_43901_);
        for (int a = 0; a < height; ++a) {
            for (int b = 0; b < inputs[a].length; ++b) {
                Ingredient ing = inputs[a][b].asVanillaIngredient();
                int i = a * width + b;
                ingredients.set(i, (Object)ing);
            }
        }
        ShapedFluxCrafterRecipe recipe = new ShapedFluxCrafterRecipe(id, width, height, (NonNullList<Ingredient>)ingredients, output.getInternal(), powerRequired, powerRate);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)INSTANCE, (Recipe)recipe));
    }

    @ZenCodeType.Method
    public static void addShapeless(String name, IItemStack output, IIngredient[] inputs, int powerRequired) {
        FluxCrafting.addShapeless(name, output, inputs, powerRequired, (Integer)ModConfigs.FLUX_CRAFTER_POWER_RATE.get());
    }

    @ZenCodeType.Method
    public static void addShapeless(String name, IItemStack output, IIngredient[] inputs, int powerRequired, int powerRate) {
        ResourceLocation id = CraftTweakerConstants.rl((String)INSTANCE.fixRecipeName(name));
        ShapelessFluxCrafterRecipe recipe = new ShapelessFluxCrafterRecipe(id, FluxCrafting.toIngredientsList(inputs), output.getInternal(), powerRequired, powerRate);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)INSTANCE, (Recipe)recipe));
    }

    @ZenCodeType.Method
    public static void remove(IItemStack stack) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveRecipe((IRecipeManager)INSTANCE, recipe -> recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_150930_(stack.getInternal().m_41720_())));
    }

    private static NonNullList<Ingredient> toIngredientsList(IIngredient ... ingredients) {
        return Arrays.stream(ingredients).map(IIngredient::asVanillaIngredient).collect(Collectors.toCollection(NonNullList::m_122779_));
    }
}

