/*
 * Decompiled with CFR 0.152.
 */
package com.bobvaraioa.kubejspowah;

import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.event.EventGroup;
import dev.latvian.mods.kubejs.event.EventHandler;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.ItemComponents;
import dev.latvian.mods.kubejs.recipe.component.NumberComponent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import dev.latvian.mods.kubejs.recipe.schema.RegisterRecipeSchemasEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import owmii.powah.api.PowahAPI;

public class KubeJSPowahPlugin
extends KubeJSPlugin {
    public static EventGroup GROUP = EventGroup.of((String)"PowahEvents");
    public static EventHandler COOLANTS = GROUP.server("registerCoolants", () -> CoolantsEvent.class);
    public static EventHandler HEAT_SOURCE = GROUP.server("registerHeatSource", () -> HeatSourceEvent.class);
    public static EventHandler MAGMATIC_FLUID = GROUP.server("registerMagmaticFluid", () -> MagmaticFluidEvent.class);

    public void registerRecipeSchemas(RegisterRecipeSchemasEvent event) {
        event.register(new ResourceLocation("powah:energizing"), EnergizingOrbRecipe.SCHEMA);
    }

    public void registerEvents() {
        GROUP.register();
    }

    static interface EnergizingOrbRecipe {
        public static final RecipeKey<InputItem[]> INPUTS = ItemComponents.UNWRAPPED_INPUT_ARRAY.key("ingredients");
        public static final RecipeKey<OutputItem> OUTPUT = ItemComponents.OUTPUT.key("result");
        public static final RecipeKey<Long> ENERGY = NumberComponent.LONG.key("energy");
        public static final RecipeSchema SCHEMA = new RecipeSchema(new RecipeKey[]{INPUTS, OUTPUT, ENERGY});
    }

    static class MagmaticFluidEvent
    extends EventJS {
        public static MagmaticFluidEvent INSTANCE = new MagmaticFluidEvent();

        MagmaticFluidEvent() {
        }

        public void add(ResourceLocation res, int heat) {
            PowahAPI.registerMagmaticFluid((ResourceLocation)res, (int)heat);
        }
    }

    static class HeatSourceEvent
    extends EventJS {
        public static HeatSourceEvent INSTANCE = new HeatSourceEvent();

        HeatSourceEvent() {
        }

        public void add(ResourceLocation res, int heat) {
            PowahAPI.registerHeatSource((ResourceLocation)res, (int)heat);
        }
    }

    static class CoolantsEvent
    extends EventJS {
        public static CoolantsEvent INSTANCE = new CoolantsEvent();

        CoolantsEvent() {
        }

        public void addFluid(ResourceLocation res, int cool) {
            PowahAPI.registerCoolant((ResourceLocation)res, (int)cool);
        }

        public void addSolid(ItemStack res, int cool) {
            PowahAPI.registerSolidCoolant((ItemLike)res.m_41720_(), (int)res.m_41613_(), (int)cool);
        }
    }
}

