/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.reskillable.common.network;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import net.bandit.reskillable.Configuration;
import net.bandit.reskillable.Reskillable;
import net.bandit.reskillable.common.commands.skills.Requirement;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class SyncSkillConfigPacket {
    private static final Logger LOGGER = Logger.getLogger(SyncSkillConfigPacket.class.getName());
    private static final int CHUNK_SIZE = 100;
    private final Map<String, Requirement[]> skillLocks;
    private final Map<String, Requirement[]> craftSkillLocks;
    private final Map<String, Requirement[]> attackSkillLocks;
    private final boolean isFinalChunk;

    public SyncSkillConfigPacket(Map<String, Requirement[]> skillLocks, Map<String, Requirement[]> craftSkillLocks, Map<String, Requirement[]> attackSkillLocks, boolean isFinalChunk) {
        this.skillLocks = skillLocks;
        this.craftSkillLocks = craftSkillLocks;
        this.attackSkillLocks = attackSkillLocks;
        this.isFinalChunk = isFinalChunk;
    }

    public SyncSkillConfigPacket(FriendlyByteBuf buf) {
        Gson gson = new Gson();
        try {
            Type mapType = new TypeToken<Map<String, Requirement[]>>(){}.getType();
            this.skillLocks = (Map)gson.fromJson(SyncSkillConfigPacket.decompress(buf.m_130052_()), mapType);
            this.craftSkillLocks = (Map)gson.fromJson(SyncSkillConfigPacket.decompress(buf.m_130052_()), mapType);
            this.attackSkillLocks = (Map)gson.fromJson(SyncSkillConfigPacket.decompress(buf.m_130052_()), mapType);
            this.isFinalChunk = buf.readBoolean();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to deserialize SyncSkillConfigPacket", e);
            throw new IllegalArgumentException("Malformed packet data", e);
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        Gson gson = new Gson();
        try {
            buf.m_130087_(SyncSkillConfigPacket.compress(gson.toJson(this.skillLocks)));
            buf.m_130087_(SyncSkillConfigPacket.compress(gson.toJson(this.craftSkillLocks)));
            buf.m_130087_(SyncSkillConfigPacket.compress(gson.toJson(this.attackSkillLocks)));
            buf.writeBoolean(this.isFinalChunk);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to serialize SyncSkillConfigPacket", e);
            throw new RuntimeException("Failed to compress packet data", e);
        }
    }

    public static void handle(SyncSkillConfigPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> CompletableFuture.runAsync(() -> SyncSkillConfigPacket.lambda$handle$0((Supplier)ctx, msg)));
        ctx.get().setPacketHandled(true);
    }

    private static void refreshClientUI() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null) {
                mc.f_91074_.m_213846_((Component)Component.m_237113_((String)"Skill configuration updated!"));
            }
        });
    }

    public static void sendToAllClients() {
        try {
            Map<String, Requirement[]> skillLocks = Configuration.getSkillLocks();
            Map<String, Requirement[]> craftSkillLocks = Configuration.getCraftSkillLocks();
            Map<String, Requirement[]> attackSkillLocks = Configuration.getAttackSkillLocks();
            if (skillLocks == null || craftSkillLocks == null || attackSkillLocks == null) {
                LOGGER.warning("Skill locks or craft/attack locks are null, not sending packet.");
                return;
            }
            ArrayList<Map.Entry<String, Requirement[]>> skillLockEntries = new ArrayList<Map.Entry<String, Requirement[]>>(skillLocks.entrySet());
            ArrayList<Map.Entry<String, Requirement[]>> craftSkillLockEntries = new ArrayList<Map.Entry<String, Requirement[]>>(craftSkillLocks.entrySet());
            ArrayList<Map.Entry<String, Requirement[]>> attackSkillLockEntries = new ArrayList<Map.Entry<String, Requirement[]>>(attackSkillLocks.entrySet());
            int maxSize = Math.max(Math.max(skillLockEntries.size(), craftSkillLockEntries.size()), attackSkillLockEntries.size());
            for (int i = 0; i < maxSize; i += 100) {
                Map<String, Requirement[]> skillLockChunk = skillLockEntries.stream().skip(i).limit(100L).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                Map<String, Requirement[]> craftSkillLockChunk = craftSkillLockEntries.stream().skip(i).limit(100L).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                Map<String, Requirement[]> attackSkillLockChunk = attackSkillLockEntries.stream().skip(i).limit(100L).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                boolean isFinalChunk = i + 100 >= maxSize;
                SyncSkillConfigPacket packet = new SyncSkillConfigPacket(skillLockChunk, craftSkillLockChunk, attackSkillLockChunk, isFinalChunk);
                Reskillable.NETWORK.send(PacketDistributor.ALL.noArg(), (Object)packet);
                LOGGER.info("Sent chunk " + (i / 100 + 1) + " to all clients.");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to send SyncSkillConfigPacket", e);
        }
    }

    private static byte[] compress(String data) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);){
            gzipOutputStream.write(data.getBytes());
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * Exception decompiling
     */
    private static String decompress(byte[] compressed) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ void lambda$handle$0(Supplier ctx, SyncSkillConfigPacket msg) {
        try {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                Configuration.setSkillLocks(msg.skillLocks);
                Configuration.setCraftSkillLocks(msg.craftSkillLocks);
                Configuration.setAttackSkillLocks(msg.attackSkillLocks);
                if (msg.isFinalChunk) {
                    SyncSkillConfigPacket.refreshClientUI();
                    LOGGER.info("All skill configuration chunks received and applied.");
                }
            } else {
                LOGGER.warning("Received SyncSkillConfigPacket on server. Ignoring.");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error updating skill locks", e);
        }
    }
}

