/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.reskillable.common.network;

import java.util.function.Supplier;
import net.bandit.reskillable.Configuration;
import net.bandit.reskillable.Reskillable;
import net.bandit.reskillable.common.capabilities.SkillModel;
import net.bandit.reskillable.common.commands.skills.Skill;
import net.bandit.reskillable.common.network.SyncToClient;
import net.bandit.reskillable.event.SoundRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class RequestLevelUp {
    private final int skillIndex;

    public RequestLevelUp(Skill skill) {
        this.skillIndex = skill.index;
    }

    public RequestLevelUp(FriendlyByteBuf buffer) {
        this.skillIndex = buffer.readInt();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.skillIndex);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            if (!Configuration.isSkillLevelingEnabled()) {
                player.m_213846_((Component)Component.m_237115_((String)"reskillable.server.disabled"));
                return;
            }
            SkillModel skillModel = SkillModel.get((Player)player);
            if (skillModel == null) {
                return;
            }
            if (this.skillIndex < 0 || this.skillIndex >= Skill.values().length) {
                return;
            }
            Skill skill = Skill.values()[this.skillIndex];
            int currentLevel = skillModel.getSkillLevel(skill);
            if (currentLevel >= Configuration.getMaxLevel()) {
                player.m_213846_((Component)Component.m_237115_((String)"reskillable.maxlevel"));
                return;
            }
            int cost = Configuration.calculateCostForLevel(currentLevel);
            if (player.m_7500_()) {
                skillModel.increaseSkillLevel(skill, (Player)player);
                SyncToClient.send((Player)player);
                return;
            }
            int playerTotalXp = this.calculateTotalXp(player);
            if (playerTotalXp >= cost) {
                this.deductXp(player, cost);
                int oldLevel = skillModel.getSkillLevel(skill);
                skillModel.increaseSkillLevel(skill, (Player)player);
                int newLevel = skillModel.getSkillLevel(skill);
                player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)SoundRegistry.LEVEL_UP_EVENT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                if (newLevel % 5 == 0) {
                    player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)SoundRegistry.MILESTONE_EVENT.get(), SoundSource.PLAYERS, 1.0f, 1.2f);
                }
                SyncToClient.send((Player)player);
            } else {
                player.m_213846_((Component)Component.m_237115_((String)"reskillable.not_enough"));
            }
        });
        context.get().setPacketHandled(true);
    }

    private int calculateTotalXp(ServerPlayer player) {
        int level = player.f_36078_;
        int progress = Math.round(player.f_36080_ * (float)this.getXpForNextLevel(level));
        return RequestLevelUp.getCumulativeXpForLevel(level) + progress;
    }

    private void deductXp(ServerPlayer player, int cost) {
        int totalXp = this.calculateTotalXp(player);
        int newTotalXp = totalXp - cost;
        player.f_36078_ = this.getLevelForTotalXp(newTotalXp);
        player.f_36080_ = this.getProgressForLevel(newTotalXp, player.f_36078_);
        player.f_36079_ = newTotalXp;
    }

    private int getXpForNextLevel(int level) {
        return Configuration.calculateExperienceCost(level);
    }

    private int getLevelForTotalXp(int totalXp) {
        int level = 0;
        while (RequestLevelUp.getCumulativeXpForLevel(level + 1) <= totalXp) {
            ++level;
        }
        return level;
    }

    private float getProgressForLevel(int totalXp, int level) {
        int levelXp = RequestLevelUp.getCumulativeXpForLevel(level);
        int nextLevelXp = RequestLevelUp.getCumulativeXpForLevel(level + 1);
        return (float)(totalXp - levelXp) / (float)(nextLevelXp - levelXp);
    }

    public static void send(Skill skill) {
        Reskillable.NETWORK.sendToServer((Object)new RequestLevelUp(skill));
    }

    public static int getCumulativeXpForLevel(int level) {
        double multiplier = Configuration.getXpScalingMultiplier();
        if (level <= 0) {
            return 0;
        }
        if (level <= 16) {
            return (int)((double)(level * (level + 1) / 2 * 2) + (double)(7 * level) * multiplier);
        }
        if (level <= 31) {
            return (int)((2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0) * multiplier);
        }
        return (int)((4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0) * multiplier);
    }

    private int calculateCost(int level) {
        return Configuration.calculateExperienceCost(level);
    }
}

