/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.reskillable.common.capabilities;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.bandit.reskillable.common.capabilities.SkillCapability;
import net.bandit.reskillable.common.capabilities.SkillModel;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class SkillProvider
implements ICapabilitySerializable<CompoundTag> {
    private final SkillModel skillModel;
    private final LazyOptional<SkillModel> optional;

    public SkillProvider() {
        this.skillModel = new SkillModel();
        this.optional = LazyOptional.of(() -> this.skillModel);
    }

    public SkillProvider(SkillModel skillModel) {
        this.skillModel = skillModel;
        this.optional = LazyOptional.of(() -> skillModel);
    }

    public void invalidate() {
        if (this.optional != null) {
            this.optional.invalidate();
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (capability == SkillCapability.INSTANCE) {
            return this.optional.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return this.skillModel.serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.skillModel.deserializeNBT(nbt);
    }
}

