/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.reskillable.common.capabilities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.bandit.reskillable.Configuration;
import net.bandit.reskillable.common.capabilities.SkillCapability;
import net.bandit.reskillable.common.commands.skills.Requirement;
import net.bandit.reskillable.common.commands.skills.RequirementType;
import net.bandit.reskillable.common.commands.skills.Skill;
import net.bandit.reskillable.common.commands.skills.SkillAttributeBonus;
import net.bandit.reskillable.common.network.SyncToClient;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.util.INBTSerializable;

public class SkillModel
implements INBTSerializable<CompoundTag> {
    private static final int DEFAULT_SKILL_COUNT = 8;
    private int[] skillLevels = new int[8];
    private int[] skillExperience = new int[8];
    private final Set<Skill> disabledPerks = new HashSet<Skill>();
    private static final UUID GLOBAL_HEALTH_BONUS_ID = UUID.nameUUIDFromBytes("reskillable:global_health_bonus".getBytes());
    private static final UUID[] ATTRIBUTE_MODIFIER_IDS = new UUID[Skill.values().length];

    public SkillModel() {
        this.resetSkills();
    }

    public int getSkillLevel(Skill skill) {
        return this.skillLevels[skill.index];
    }

    public void setSkillLevel(Skill skill, int level) {
        this.skillLevels[skill.index] = Math.min(level, Configuration.getMaxLevel());
    }

    public void increaseSkillLevel(Skill skill, Player player) {
        int currentLevel = this.skillLevels[skill.index];
        if (currentLevel < Configuration.getMaxLevel()) {
            int n = skill.index;
            this.skillLevels[n] = this.skillLevels[n] + 1;
            this.skillExperience[skill.index] = 0;
            this.updateSkillAttributeBonuses(player);
            this.syncSkills(player);
            this.updateSkillAttributeBonuses(player);
            int newLevel = this.skillLevels[skill.index];
            if (newLevel % 5 == 0) {
                SkillAttributeBonus bonus = SkillAttributeBonus.getBySkill(skill);
                Attribute attr = bonus.getAttribute();
                if (bonus != null && attr != null) {
                    double amount = bonus.getBonusPerStep();
                    String string = attr.m_22087_().replace("attribute.name.", "");
                }
            }
        }
    }

    public void addExperience(Skill skill, int experience) {
        int n = skill.index;
        this.skillExperience[n] = this.skillExperience[n] + experience;
        this.checkForLevelUp(skill);
    }

    private void checkForLevelUp(Skill skill) {
        int xp;
        int level = this.skillLevels[skill.index];
        for (xp = this.skillExperience[skill.index]; level < Configuration.getMaxLevel() && xp >= Configuration.calculateExperienceCost(level); xp -= Configuration.calculateExperienceCost(level), ++level) {
        }
        this.skillExperience[skill.index] = xp;
        this.skillLevels[skill.index] = level;
    }

    public boolean hasSufficientXP(Player player, Skill skill) {
        if (player.m_7500_() || player.m_9236_().f_46443_) {
            return true;
        }
        int totalXP = this.calculateTotalXPFromPlayer(player);
        return totalXP >= Configuration.calculateExperienceCost(this.getSkillLevel(skill));
    }

    private int calculateTotalXPFromPlayer(Player player) {
        int level = player.f_36078_;
        int progress = Math.round(player.f_36080_ * (float)Configuration.calculateExperienceCost(level));
        return Configuration.getCumulativeXpForLevel(level) + progress;
    }

    public boolean canUseItem(Player player, ItemStack item) {
        return this.canUse(player, item.m_41720_().m_204114_().m_205785_().m_135782_());
    }

    public boolean canUseBlock(Player player, Block block) {
        return this.canUse(player, block.m_204297_().m_205785_().m_135782_());
    }

    public boolean canUseEntity(Player player, Entity entity) {
        return this.canUse(player, entity.m_6095_().m_204041_().m_205785_().m_135782_());
    }

    private boolean canUse(Player player, ResourceLocation resource) {
        return this.checkRequirements(player, resource, RequirementType.USE);
    }

    private boolean checkRequirements(Player player, ResourceLocation resource, RequirementType type) {
        Requirement[] requirements = type.getRequirements(resource);
        if (requirements == null || requirements.length == 0) {
            return true;
        }
        ArrayList<Requirement> unmetRequirements = new ArrayList<Requirement>();
        for (Requirement requirement : requirements) {
            if (this.getSkillLevel(requirement.skill) >= requirement.level) continue;
            unmetRequirements.add(requirement);
        }
        if (!unmetRequirements.isEmpty()) {
            this.sendSkillRequirementMessage(player, type, unmetRequirements);
            return false;
        }
        return true;
    }

    private void sendSkillRequirementMessage(Player player, RequirementType type, List<Requirement> unmetRequirements) {
        String translationKey = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case RequirementType.ATTACK -> "message.reskillable.requirement.attack";
            case RequirementType.CRAFT -> "message.reskillable.requirement.craft";
            case RequirementType.USE -> "message.reskillable.requirement.use";
        };
        ArrayList<MutableComponent> formattedRequirements = new ArrayList<MutableComponent>();
        for (Requirement req : unmetRequirements) {
            String skillTranslationKey = "skill." + req.skill.name().toLowerCase();
            MutableComponent translatedSkillName = Component.m_237115_((String)skillTranslationKey);
            formattedRequirements.add(Component.m_237113_((String)"").m_7220_((Component)translatedSkillName).m_130946_(" level " + req.level));
        }
        MutableComponent joinedRequirements = Component.m_237113_((String)" ").m_7220_((Component)Component.m_237113_((String)String.join((CharSequence)", ", formattedRequirements.stream().map(Component::getString).collect(Collectors.toList()))));
        MutableComponent message = Component.m_237110_((String)translationKey, (Object[])new Object[]{joinedRequirements});
        player.m_5661_((Component)message, true);
    }

    public static SkillModel get(Player player) {
        return (SkillModel)player.getCapability(SkillCapability.INSTANCE).orElse(null);
    }

    public boolean canCraftItem(Player player, ItemStack stack) {
        ResourceLocation resource = stack.m_41720_().m_204114_().m_205785_().m_135782_();
        return this.checkRequirements(player, resource, RequirementType.CRAFT);
    }

    public boolean canAttackEntity(Player player, Entity target) {
        ResourceLocation resource = target.m_6095_().m_204041_().m_205785_().m_135782_();
        return this.checkRequirements(player, resource, RequirementType.ATTACK);
    }

    public void syncSkills(Player player) {
        if (player instanceof ServerPlayer) {
            SyncToClient.send(player);
        }
    }

    public void resetSkills() {
        for (int i = 0; i < 8; ++i) {
            this.skillLevels[i] = 1;
            this.skillExperience[i] = 0;
        }
    }

    public void cloneFrom(SkillModel source) {
        this.skillLevels = (int[])source.skillLevels.clone();
        this.skillExperience = (int[])source.skillExperience.clone();
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128385_("skillLevels", this.skillLevels);
        compound.m_128385_("skillExperience", this.skillExperience);
        List disabledSkillNames = this.disabledPerks.stream().map(skill -> skill.name()).collect(Collectors.toList());
        compound.m_128385_("skillLevels", this.skillLevels);
        compound.m_128385_("skillExperience", this.skillExperience);
        CompoundTag disabledTag = new CompoundTag();
        for (Skill skill2 : this.disabledPerks) {
            disabledTag.m_128379_(skill2.name(), true);
        }
        compound.m_128365_("disabledPerks", (Tag)disabledTag);
        return compound;
    }

    public void deserializeNBT(CompoundTag nbt) {
        int[] loadedLevels = nbt.m_128465_("skillLevels");
        int[] loadedExperience = nbt.m_128465_("skillExperience");
        if (loadedLevels.length == 8) {
            this.skillLevels = loadedLevels;
        }
        if (loadedExperience.length == 8) {
            this.skillExperience = loadedExperience;
        }
        this.disabledPerks.clear();
        if (nbt.m_128425_("disabledPerks", 10)) {
            CompoundTag disabledTag = nbt.m_128469_("disabledPerks");
            for (String key : disabledTag.m_128431_()) {
                try {
                    Skill skill = Skill.valueOf(key);
                    this.disabledPerks.add(skill);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    public void updateSkillAttributeBonuses(Player player) {
        for (SkillAttributeBonus bonus : SkillAttributeBonus.values()) {
            int skillLevel;
            int bonusSteps;
            double totalBonus;
            Attribute attr = bonus.getAttribute();
            if (attr == null) continue;
            UUID modifierId = UUID.nameUUIDFromBytes(("reskillable:" + bonus.skill.name().toLowerCase()).getBytes());
            AttributeInstance attrInstance = player.m_21051_(attr);
            if (attrInstance == null) continue;
            attrInstance.m_22122_().stream().filter(mod -> mod.m_22209_().equals(modifierId)).forEach(arg_0 -> ((AttributeInstance)attrInstance).m_22130_(arg_0));
            if (!this.isPerkEnabled(bonus.skill) || !((totalBonus = (double)(bonusSteps = (skillLevel = this.getSkillLevel(bonus.skill)) / 5) * bonus.getBonusPerStep()) > 0.0)) continue;
            AttributeModifier modifier = new AttributeModifier(modifierId, "Reskillable Bonus: " + bonus.skill.name(), totalBonus, bonus.operation);
            attrInstance.m_22118_(modifier);
        }
        this.handleHealthBonus(player);
    }

    private void handleHealthBonus(Player player) {
        if (!((Boolean)Configuration.HEALTH_BONUS.get()).booleanValue()) {
            return;
        }
        int totalSkillLevels = Arrays.stream(this.skillLevels).sum();
        int levelsPerHeart = (Integer)Configuration.LEVELS_PER_HEART.get();
        double healthPerHeart = (Double)Configuration.HEALTH_PER_HEART.get();
        int hearts = totalSkillLevels / levelsPerHeart;
        double healthBonus = (double)hearts * healthPerHeart;
        AttributeInstance healthAttr = player.m_21051_(Attributes.f_22276_);
        if (healthAttr != null) {
            healthAttr.m_22120_(GLOBAL_HEALTH_BONUS_ID);
            if (healthBonus > 0.0) {
                AttributeModifier healthModifier = new AttributeModifier(GLOBAL_HEALTH_BONUS_ID, "Reskillable Total Level Bonus", healthBonus, AttributeModifier.Operation.ADDITION);
                healthAttr.m_22118_(healthModifier);
            }
        }
    }

    public boolean isPerkEnabled(Skill skill) {
        return !this.disabledPerks.contains((Object)skill);
    }

    public void togglePerk(Skill skill, Player player) {
        if (!this.disabledPerks.add(skill)) {
            this.disabledPerks.remove((Object)skill);
        }
        this.updateSkillAttributeBonuses(player);
        this.syncSkills(player);
    }

    static {
        for (int i = 0; i < ATTRIBUTE_MODIFIER_IDS.length; ++i) {
            SkillModel.ATTRIBUTE_MODIFIER_IDS[i] = UUID.nameUUIDFromBytes(("reskillable:skill_bonus_" + i).getBytes());
        }
    }
}

