/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.reskillable.common;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.bandit.reskillable.Configuration;
import net.bandit.reskillable.common.capabilities.SkillModel;
import net.bandit.reskillable.common.capabilities.SkillProvider;
import net.bandit.reskillable.common.commands.skills.Skill;
import net.bandit.reskillable.common.commands.skills.SkillAttributeBonus;
import net.bandit.reskillable.common.network.SyncToClient;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventHandler {
    private SkillModel lastDiedPlayerSkills = null;
    private static final Map<UUID, SkillModel> lastDiedPlayerSkillsMap = new ConcurrentHashMap<UUID, SkillModel>();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        SkillModel model = SkillModel.get(player);
        if (model == null) {
            return;
        }
        ItemStack item = event.getItemStack();
        Block block = event.getLevel().m_8055_(event.getPos()).m_60734_();
        if (!(player.m_7500_() || model.canUseItem(player, item) && model.canUseBlock(player, block))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        SkillModel model = SkillModel.get(player);
        if (model == null) {
            return;
        }
        ItemStack item = event.getItemStack();
        Block block = event.getLevel().m_8055_(event.getPos()).m_60734_();
        if (!(player.m_7500_() || model.canUseItem(player, item) && model.canUseBlock(player, block))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        SkillModel model = SkillModel.get(player);
        if (model == null) {
            return;
        }
        ItemStack item = event.getItemStack();
        if (!player.m_7500_() && !model.canUseItem(player, item)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        SkillModel model = SkillModel.get(player);
        if (model == null) {
            return;
        }
        Entity entity = event.getTarget();
        ItemStack item = event.getItemStack();
        if (!(player.m_7500_() || model.canUseEntity(player, entity) && model.canUseItem(player, item))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onAttackEntity(AttackEntityEvent event) {
        Player player = event.getEntity();
        SkillModel model = SkillModel.get(player);
        if (model == null || player.m_7500_()) {
            return;
        }
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        boolean canUseMain = model.canUseItem(player, mainHand);
        boolean canUseOff = model.canUseItem(player, offHand);
        if (!(canUseMain && canUseOff && model.canAttackEntity(player, event.getTarget()))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onChangeEquipment(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            ItemStack item;
            Player player = (Player)livingEntity;
            SkillModel model = SkillModel.get(player);
            if (model == null) {
                return;
            }
            if (!player.m_7500_() && event.getSlot().m_20743_() == EquipmentSlot.Type.ARMOR && !model.canUseItem(player, item = event.getTo())) {
                player.m_36176_(item.m_41777_(), false);
                item.m_41764_(0);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityDrops(LivingDropsEvent event) {
        if (Configuration.getDisableWool() && event.getEntity() instanceof Sheep) {
            event.getDrops().removeIf(item -> item.m_32055_().m_204117_(ItemTags.f_13167_));
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).m_9236_().m_5776_()) {
            SkillModel model = SkillModel.get(player);
            if (model == null) {
                return;
            }
            if (Configuration.getDeathReset() && !lastDiedPlayerSkillsMap.containsKey(player.m_20148_())) {
                model.resetSkills();
            }
            lastDiedPlayerSkillsMap.put(player.m_20148_(), model);
        }
    }

    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            SkillModel skillModel = new SkillModel();
            SkillProvider provider = new SkillProvider(skillModel);
            event.addCapability(new ResourceLocation("reskillable", "cap_skills"), (ICapabilityProvider)provider);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        Player original = event.getOriginal();
        Player clone = event.getEntity();
        original.reviveCaps();
        SkillModel originalModel = SkillModel.get(original);
        SkillModel cloneModel = SkillModel.get(clone);
        if (originalModel != null && cloneModel != null) {
            cloneModel.cloneFrom(originalModel);
            cloneModel.syncSkills(clone);
            cloneModel.updateSkillAttributeBonuses(clone);
        }
        original.invalidateCaps();
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        SkillModel skillModel = SkillModel.get(player);
        if (skillModel != null) {
            SyncToClient.send(player);
            skillModel.updateSkillAttributeBonuses(player);
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        SkillModel skillModel;
        Player player = event.getEntity();
        SkillModel model = SkillModel.get(player);
        if (!player.m_9236_().m_5776_() && (skillModel = SkillModel.get(player)) != null) {
            SyncToClient.send(player);
            model.updateSkillAttributeBonuses(player);
        }
    }

    @SubscribeEvent
    public void onChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        SkillModel skillModel;
        Player player = event.getEntity();
        SkillModel model = SkillModel.get(player);
        if (!player.m_9236_().m_5776_() && (skillModel = SkillModel.get(player)) != null) {
            skillModel.syncSkills(player);
            model.updateSkillAttributeBonuses(player);
        }
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        SkillAttributeBonus bonus;
        int miningLevel;
        Player player = event.getEntity();
        SkillModel model = SkillModel.get(player);
        if (model != null && (miningLevel = model.getSkillLevel(Skill.MINING)) >= 5 && (bonus = SkillAttributeBonus.getBySkill(Skill.MINING)) != null && model.isPerkEnabled(Skill.MINING)) {
            float multiplier = 1.0f + (float)miningLevel / 5.0f * (float)bonus.getBonusPerStep();
            event.setNewSpeed(event.getNewSpeed() * multiplier);
        }
    }

    @SubscribeEvent
    public void onCropGrow(BlockEvent.CropGrowEvent.Pre event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        level.m_6907_().forEach(player -> {
            SkillModel model;
            if (player.m_20238_(Vec3.m_82512_((Vec3i)event.getPos())) < 64.0 && (model = SkillModel.get((Player)player)) != null) {
                int farmingLevel = model.getSkillLevel(Skill.FARMING);
                SkillAttributeBonus bonus = SkillAttributeBonus.getBySkill(Skill.FARMING);
                if (bonus != null && model.isPerkEnabled(Skill.FARMING)) {
                    float chance = (float)farmingLevel / 5.0f * (float)bonus.getBonusPerStep();
                    if (farmingLevel >= 5 && level.f_46441_.m_188501_() < chance) {
                        event.setResult(Event.Result.ALLOW);
                    }
                }
            }
        });
    }

    @SubscribeEvent
    public void onXpPickup(PlayerXpEvent.PickupXp event) {
        double bonusPercentPerStep;
        int bonusSteps;
        float originalXp;
        int bonusXp;
        Player player = event.getEntity();
        if (player.m_9236_().f_46443_) {
            return;
        }
        SkillModel model = SkillModel.get(player);
        if (model == null || !model.isPerkEnabled(Skill.GATHERING)) {
            return;
        }
        int gatheringLevel = model.getSkillLevel(Skill.GATHERING);
        if (gatheringLevel < 5) {
            return;
        }
        SkillAttributeBonus bonus = SkillAttributeBonus.getBySkill(Skill.GATHERING);
        if (bonus != null && (bonusXp = Math.round((originalXp = (float)event.getOrb().f_20770_) * (float)((double)(bonusSteps = gatheringLevel / 5) * (bonusPercentPerStep = bonus.getBonusPerStep())))) > 0) {
            player.m_6756_(bonusXp);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().f_46443_) {
            return;
        }
        if (event.player.f_19797_ % 20 != 0) {
            return;
        }
        Player player = event.player;
        SkillModel model = SkillModel.get(player);
        if (model == null) {
            return;
        }
        for (SkillAttributeBonus bonus : SkillAttributeBonus.values()) {
            if (bonus.getAttribute() == null) continue;
        }
    }

    @SubscribeEvent
    public void onPlayerEquipmentChange(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        SkillModel model = SkillModel.get(player);
        if (model == null || player.m_9236_().f_46443_) {
            return;
        }
        model.updateSkillAttributeBonuses(player);
    }

    @SubscribeEvent
    public void onPlayerTickAgility(TickEvent.PlayerTickEvent event) {
        double multiplier;
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().f_46443_) {
            return;
        }
        Player player = event.player;
        SkillModel model = SkillModel.get(player);
        if (model == null) {
            return;
        }
        AttributeInstance attribute = player.m_21051_(Attributes.f_22279_);
        if (attribute == null) {
            return;
        }
        SkillAttributeBonus bonus = SkillAttributeBonus.getBySkill(Skill.AGILITY);
        if (bonus == null) {
            return;
        }
        UUID agilityId = UUID.nameUUIDFromBytes("reskillable:agility".getBytes());
        attribute.m_22120_(agilityId);
        int agilityLevel = model.getSkillLevel(Skill.AGILITY);
        if (agilityLevel >= 5 && model.isPerkEnabled(Skill.AGILITY) && (multiplier = (double)agilityLevel / 5.0 * bonus.getBonusPerStep()) > 0.0) {
            AttributeModifier mod = new AttributeModifier(agilityId, "Reskillable AGILITY bonus", multiplier, AttributeModifier.Operation.MULTIPLY_TOTAL);
            attribute.m_22118_(mod);
        }
    }
}

