/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.reskillable.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.bandit.reskillable.Configuration;
import net.bandit.reskillable.client.screen.buttons.SkillButton;
import net.bandit.reskillable.common.capabilities.SkillModel;
import net.bandit.reskillable.common.commands.skills.Skill;
import net.bandit.reskillable.common.commands.skills.SkillAttributeBonus;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class SkillScreen
extends Screen {
    public static final ResourceLocation RESOURCES = new ResourceLocation("reskillable", "textures/gui/skills.png");
    private final Map<Skill, String> xpCostDisplay = new HashMap<Skill, String>();
    private final Map<Skill, Integer> xpCostColor = new HashMap<Skill, Integer>();

    public SkillScreen() {
        super((Component)Component.m_237119_());
    }

    protected void m_7856_() {
        int left = (this.f_96543_ - 162) / 2;
        int top = (this.f_96544_ - 128) / 2;
        for (int i = 0; i < 8; ++i) {
            int x = left + i % 2 * 83;
            int y = top + i / 2 * 36;
            Skill skill = Skill.values()[i];
            this.m_142416_((GuiEventListener)new SkillButton(x, y, skill));
        }
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)RESOURCES);
        int left = (this.f_96543_ - 176) / 2;
        int top = (this.f_96544_ - 166) / 2;
        this.m_280273_(guiGraphics);
        guiGraphics.m_280218_(RESOURCES, left, top, 0, 0, 176, 166);
        int i = 0;
        for (Skill skill : Skill.values()) {
            int x = left + i % 2 * 83 + 10;
            int y = top + i / 2 * 36 + 20;
            String xpCost = this.xpCostDisplay.getOrDefault((Object)skill, "N/A");
            int color = this.xpCostColor.getOrDefault((Object)skill, 0xFFFFFF);
            guiGraphics.m_280056_(this.f_96547_, "XP: " + xpCost, x, y, color, false);
            ++i;
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        int labelX = this.f_96543_ / 2 - this.f_96547_.m_92895_("Skills") / 2;
        int labelY = top + 6;
        if (mouseX > labelX && mouseX < labelX + this.f_96547_.m_92895_("Skills") && mouseY > labelY) {
            Objects.requireNonNull(this.f_96547_);
            if (mouseY < labelY + 9) {
                this.renderTotalXPTooltip(guiGraphics, mouseX, mouseY);
            }
        }
        for (Renderable widget : this.f_169369_) {
            SkillButton button;
            if (!(widget instanceof SkillButton) || !(button = (SkillButton)widget).m_5953_(mouseX, mouseY)) continue;
            List<Component> tooltipLines = button.getTooltipLines((Player)Minecraft.m_91087_().f_91074_);
            guiGraphics.m_280245_(this.f_96547_, tooltipLines.stream().map(Component::m_7532_).toList(), mouseX, mouseY);
        }
    }

    private void renderTotalXPTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            int totalXP = this.calculateTotalXP((Player)player);
            int level = this.getLevelForTotalXP(totalXP);
            MutableComponent totalXPComponent = Component.m_237113_((String)String.valueOf(totalXP)).m_130940_(ChatFormatting.GREEN);
            MutableComponent levelComponent = Component.m_237113_((String)String.valueOf(level));
            MutableComponent tooltip = Component.m_237110_((String)"tooltip.rereskillable.total_xp", (Object[])new Object[]{totalXPComponent, levelComponent});
            ArrayList<MutableComponent> tooltipLines = new ArrayList<MutableComponent>();
            tooltipLines.add(tooltip);
            tooltipLines.add(Component.m_237113_((String)" "));
            SkillModel model = SkillModel.get((Player)player);
            if (model != null) {
                for (Skill skill : Skill.values()) {
                    MutableComponent bonusLine;
                    Attribute attribute;
                    int skillLevel = model.getSkillLevel(skill);
                    SkillAttributeBonus bonus = SkillAttributeBonus.getBySkill(skill);
                    Attribute attribute2 = attribute = bonus != null ? bonus.getAttribute() : null;
                    if (bonus != null && attribute != null && skillLevel >= 5) {
                        double amount = (double)skillLevel / 5.0 * bonus.getBonusPerStep();
                        if (!(amount > 0.0)) continue;
                        MutableComponent skillName = Component.m_237115_((String)("skill." + skill.name().toLowerCase())).m_130940_(ChatFormatting.GOLD);
                        MutableComponent attrName = Component.m_237115_((String)attribute.m_22087_()).m_130940_(ChatFormatting.GRAY);
                        String percentText = String.format("+%.0f%%", amount * 100.0);
                        MutableComponent bonusLine2 = Component.m_237113_((String)"").m_7220_((Component)skillName).m_130946_(": ").m_7220_((Component)Component.m_237113_((String)percentText).m_130940_(ChatFormatting.AQUA)).m_130946_(" ").m_7220_((Component)attrName);
                        tooltipLines.add(bonusLine2);
                        continue;
                    }
                    MutableComponent skillName = Component.m_237115_((String)("skill." + skill.name().toLowerCase())).m_130940_(ChatFormatting.GOLD);
                    switch (skill) {
                        case AGILITY: {
                            MutableComponent mutableComponent = Component.m_237113_((String)"").m_7220_((Component)skillName).m_130946_(": ").m_7220_((Component)Component.m_237113_((String)(skillLevel >= 5 ? String.format("+%.0f%%", (double)skillLevel / 5.0 * 25.0) : "+0%")).m_130940_(ChatFormatting.AQUA)).m_130946_(" ").m_7220_((Component)Component.m_237113_((String)"Run Speed").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)(skillLevel < 5 ? Component.m_237113_((String)" (Requires Level 5)").m_130940_(ChatFormatting.DARK_GRAY) : Component.m_237119_()));
                            break;
                        }
                        case MINING: {
                            MutableComponent mutableComponent = Component.m_237113_((String)"").m_7220_((Component)skillName).m_130946_(": ").m_7220_((Component)Component.m_237113_((String)(skillLevel >= 5 ? String.format("+%.0f%%", (double)skillLevel / 5.0 * 25.0) : "+0%")).m_130940_(ChatFormatting.AQUA)).m_130946_(" ").m_7220_((Component)Component.m_237113_((String)"Break Speed").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)(skillLevel < 5 ? Component.m_237113_((String)" (Requires Level 5)").m_130940_(ChatFormatting.DARK_GRAY) : Component.m_237119_()));
                            break;
                        }
                        case GATHERING: {
                            MutableComponent mutableComponent = Component.m_237113_((String)"").m_7220_((Component)skillName).m_130946_(": ").m_7220_((Component)Component.m_237113_((String)(skillLevel >= 5 ? String.format("+%.0f%%", (double)skillLevel / 5.0 * (Double)Configuration.GATHERING_XP_BONUS.get() * 100.0) : "+0%")).m_130940_(ChatFormatting.AQUA)).m_130946_(" ").m_7220_((Component)Component.m_237113_((String)"Bonus XP from Orbs").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)(skillLevel < 5 ? Component.m_237113_((String)" (Requires Level 5)").m_130940_(ChatFormatting.DARK_GRAY) : Component.m_237119_()));
                            break;
                        }
                        case FARMING: {
                            MutableComponent mutableComponent = Component.m_237113_((String)"").m_7220_((Component)skillName).m_130946_(": ").m_7220_((Component)Component.m_237113_((String)(skillLevel >= 5 ? "+" + (int)((double)skillLevel / 5.0 * 25.0) + "%" : "+0%")).m_130940_(ChatFormatting.AQUA)).m_130946_(" ").m_7220_((Component)Component.m_237113_((String)"Crop Growth").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)(skillLevel < 5 ? Component.m_237113_((String)" (Requires Level 5)").m_130940_(ChatFormatting.DARK_GRAY) : Component.m_237119_()));
                            break;
                        }
                        default: {
                            MutableComponent mutableComponent = bonusLine = null;
                        }
                    }
                    if (bonusLine == null) continue;
                    tooltipLines.add(bonusLine);
                }
            }
            guiGraphics.m_280245_(Minecraft.m_91087_().f_91062_, tooltipLines.stream().map(Component::m_7532_).toList(), mouseX, mouseY);
        }
    }

    private int calculateTotalXP(Player player) {
        int level = player.f_36078_;
        float progress = player.f_36080_;
        if (level <= 16) {
            return level * level + 6 * level + Math.round(progress * (float)(2 * level + 7));
        }
        if (level <= 31) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0) + Math.round(progress * (float)(5 * level - 38));
        }
        return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0) + Math.round(progress * (float)(9 * level - 158));
    }

    private int getLevelForTotalXP(int totalXP) {
        int level = 0;
        while (this.getCumulativeXPForLevel(level + 1) <= totalXP) {
            ++level;
        }
        return level;
    }

    private int getCumulativeXPForLevel(int level) {
        if (level <= 0) {
            return 0;
        }
        if (level <= 16) {
            return level * (level + 1) + level * 6;
        }
        if (level <= 31) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_86600_() {
        super.m_86600_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            SkillModel skillModel = SkillModel.get((Player)player);
            for (Skill skill : Skill.values()) {
                int skillLevel = skillModel.getSkillLevel(skill);
                int xpCost = Configuration.calculateExperienceCost(skillLevel);
                boolean hasXP = skillModel.hasSufficientXP((Player)player, skill);
                this.xpCostDisplay.put(skill, String.valueOf(xpCost));
                this.xpCostColor.put(skill, hasXP ? 65280 : 0xFF0000);
            }
        }
    }
}

