/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.structurecompass.client.screen;

import com.mrbysco.structurecompass.client.screen.widget.StructureListWidget;
import com.mrbysco.structurecompass.compat.gamestages.GameStagesHelper;
import com.mrbysco.structurecompass.network.PacketHandler;
import com.mrbysco.structurecompass.network.message.SetStructureMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.StringUtils;
import net.minecraftforge.network.PacketDistributor;

public class CompassScreen
extends Screen {
    private static final int PADDING = 6;
    private StructureListWidget structureWidget;
    private StructureListWidget.ListEntry selected = null;
    private int listWidth;
    private List<ResourceLocation> structures;
    private final List<ResourceLocation> unsortedStructures;
    private Button loadButton;
    private final InteractionHand usedHand;
    private final ItemStack compassStack;
    private final int buttonMargin = 1;
    private final int numButtons = SortType.values().length;
    private String lastFilterText = "";
    private EditBox search;
    private boolean sorted = false;
    private SortType sortType = SortType.NORMAL;

    public CompassScreen(InteractionHand hand, ItemStack compass, List<ResourceLocation> allStructures) {
        super((Component)Component.m_237115_((String)"structurecompass:compass.screen"));
        this.usedHand = hand;
        this.compassStack = compass;
        ArrayList<ResourceLocation> structureList = new ArrayList<ResourceLocation>();
        for (ResourceLocation id : allStructures) {
            if (id == null) continue;
            structureList.add(id);
        }
        if (ModList.get().isLoaded("gamestages")) {
            structureList.removeIf(location -> !GameStagesHelper.doesPlayerHaveRequiredStage(location));
        }
        Collections.sort(structureList);
        this.structures = Collections.unmodifiableList(structureList);
        this.unsortedStructures = Collections.unmodifiableList(allStructures);
    }

    public boolean m_7043_() {
        return false;
    }

    protected void m_7856_() {
        int centerWidth = this.f_96543_ / 2;
        for (ResourceLocation structureLocation : this.structures) {
            this.listWidth = Math.max(this.listWidth, this.getFontRenderer().m_92895_(structureLocation.toString()) + 10);
        }
        this.listWidth = Math.max(Math.min(this.listWidth, this.f_96543_ / 3), 200);
        this.listWidth += this.listWidth % this.numButtons != 0 ? this.numButtons - this.listWidth % this.numButtons : 0;
        int structureWidth = this.f_96543_ - this.listWidth - 18;
        int closeButtonWidth = Math.min(structureWidth, 200);
        int y = this.f_96544_ - 20 - 6;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.cancel"), b -> this.m_7379_()).m_252987_(centerWidth - closeButtonWidth / 2 + 6, y, closeButtonWidth, 20).m_253136_());
        this.loadButton = Button.m_253074_((Component)Component.m_237115_((String)"structurecompass.screen.selection.select"), b -> {
            if (this.selected != null) {
                PacketHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new SetStructureMessage(this.usedHand, this.selected.getStructureLocation()));
            }
            if (this.f_96541_.f_91074_ != null && this.selected != null) {
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237110_((String)"structurecompass.screen.selection.selected", (Object[])new Object[]{this.selected.getStructureLocation()}).m_130940_(ChatFormatting.GOLD));
            }
            this.m_7379_();
        }).m_252987_(centerWidth - closeButtonWidth / 2 + 6, y -= 24, closeButtonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.loadButton);
        this.search = new EditBox(this.getFontRenderer(), centerWidth - this.listWidth / 2 + 6 + 1, y -= 20, this.listWidth - 2, 14, (Component)Component.m_237115_((String)"structurecompass.screen.search"));
        int fullButtonHeight = 32;
        int n = this.search.m_252907_();
        Objects.requireNonNull(this.getFontRenderer());
        this.structureWidget = new StructureListWidget(this, this.f_96543_, fullButtonHeight, n - 9 - 6);
        this.structureWidget.m_93507_(0);
        this.m_7787_((GuiEventListener)this.search);
        this.m_7787_((GuiEventListener)this.structureWidget);
        this.search.m_93692_(false);
        this.search.m_94190_(true);
        if (this.compassStack.m_41782_() && this.compassStack.m_41783_().m_128441_("structurecompass:structureName")) {
            String structure = this.compassStack.m_41783_().m_128461_("structurecompass:structureName");
            this.search.m_94144_(structure);
        }
        int width = this.listWidth / this.numButtons;
        int x = centerWidth + 6 - width;
        SortType.A_TO_Z.button = Button.m_253074_((Component)SortType.A_TO_Z.getButtonText(), b -> this.resortStructures(SortType.A_TO_Z)).m_252987_(x, 6, width - 1, 20).m_253136_();
        this.m_142416_((GuiEventListener)SortType.A_TO_Z.button);
        SortType.Z_TO_A.button = Button.m_253074_((Component)SortType.Z_TO_A.getButtonText(), b -> this.resortStructures(SortType.Z_TO_A)).m_252987_(x += width + 1, 6, width - 1, 20).m_253136_();
        this.m_142416_((GuiEventListener)SortType.Z_TO_A.button);
        this.resortStructures(SortType.A_TO_Z);
        this.updateCache();
    }

    public void m_86600_() {
        this.search.m_94120_();
        this.structureWidget.m_6987_((AbstractSelectionList.Entry)this.selected);
        if (!this.search.m_94155_().equals(this.lastFilterText)) {
            this.reloadStructures();
            this.sorted = false;
        }
        if (!this.sorted) {
            this.reloadStructures();
            if (this.sortType == SortType.A_TO_Z) {
                Collections.sort(this.structures);
            } else if (this.sortType == SortType.Z_TO_A) {
                this.structures.sort(Collections.reverseOrder());
            }
            this.checkStages();
            this.structureWidget.refreshList();
            if (this.selected != null) {
                this.selected = this.structureWidget.m_6702_().stream().filter(e -> e == this.selected).findFirst().orElse(null);
                this.updateCache();
            }
            this.sorted = true;
        }
    }

    public <T extends ObjectSelectionList.Entry<T>> void buildStructureList(Consumer<T> ListViewConsumer, Function<ResourceLocation, T> newEntry) {
        this.structures.forEach(mod -> ListViewConsumer.accept((ObjectSelectionList.Entry)newEntry.apply((ResourceLocation)mod)));
    }

    private void reloadStructures() {
        this.structures = this.unsortedStructures.stream().filter(struc -> StringUtils.toLowerCase((String)struc.toString()).contains(StringUtils.toLowerCase((String)this.search.m_94155_()))).collect(Collectors.toList());
        this.checkStages();
        this.lastFilterText = this.search.m_94155_();
    }

    private void checkStages() {
        if (ModList.get().isLoaded("gamestages")) {
            this.structures.removeIf(location -> !GameStagesHelper.doesPlayerHaveRequiredStage(location));
        }
    }

    private void resortStructures(SortType newSort) {
        this.sortType = newSort;
        for (SortType sort : SortType.values()) {
            if (sort.button == null) continue;
            sort.button.f_93623_ = this.sortType != sort;
        }
        this.sorted = false;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.structureWidget.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        MutableComponent text = Component.m_237115_((String)"structurecompass.screen.search");
        Font font = this.getFontRenderer();
        int n = this.f_96543_ / 2 + 6;
        int n2 = this.search.m_252907_();
        Objects.requireNonNull(this.getFontRenderer());
        guiGraphics.m_280653_(font, (Component)text, n, n2 - 9 - 2, 0xFFFFFF);
        this.search.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public Font getFontRenderer() {
        return this.f_96547_;
    }

    public void setSelected(StructureListWidget.ListEntry entry) {
        this.selected = entry == this.selected ? null : entry;
        this.updateCache();
    }

    private void updateCache() {
        this.loadButton.f_93623_ = this.selected != null;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean flag = super.m_6375_(mouseX, mouseY, button);
        if (button == 1 && this.search.m_5953_(mouseX, mouseY)) {
            this.search.m_94144_("");
        }
        return flag;
    }

    public void m_6574_(Minecraft mc, int width, int height) {
        String s = this.search.m_94155_();
        SortType sort = this.sortType;
        StructureListWidget.ListEntry selected = this.selected;
        this.m_6575_(mc, width, height);
        this.search.m_94144_(s);
        this.selected = selected;
        if (!this.search.m_94155_().isEmpty()) {
            this.reloadStructures();
        }
        if (sort != SortType.NORMAL) {
            this.resortStructures(sort);
        }
        this.updateCache();
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(null);
    }

    private static enum SortType {
        NORMAL,
        A_TO_Z,
        Z_TO_A;

        Button button;

        Component getButtonText() {
            return Component.m_237115_((String)("structurecompass.screen.search." + this.name().toLowerCase(Locale.ROOT)));
        }
    }
}

