/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.spells.aqua;

import com.gametechbc.traveloptics.api.init.TravelopticsSchools;
import com.gametechbc.traveloptics.init.TravelopticsEffects;
import com.gametechbc.traveloptics.init.TravelopticsSounds;
import com.gametechbc.traveloptics.spells.TravelopticsSpellAnimations;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.TargetEntityCastData;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class TidalGraspSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("traveloptics", "tidal_grasp");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchoolResource(TravelopticsSchools.AQUA_RESOURCE).setMaxLevel(6).setCooldownSeconds(20.0).build();

    public TidalGraspSpell() {
        this.baseManaCost = 40;
        this.manaCostPerLevel = 40;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 15;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)TravelopticsSounds.TIDAL_GRASP_PULL.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    public AnimationHolder getCastStartAnimation() {
        return TravelopticsSpellAnimations.TIDAL_GRASP;
    }

    public AnimationHolder getCastFinishAnimation() {
        return TravelopticsSpellAnimations.TIDAL_GRASP_SMACK;
    }

    public boolean canBeInterrupted(@Nullable Player player) {
        return false;
    }

    public int getEffectiveCastTime(int spellLevel, @Nullable LivingEntity entity) {
        return this.getCastTime(spellLevel);
    }

    public boolean checkPreCastConditions(Level level, int spellLevel, LivingEntity caster, MagicData playerMagicData) {
        return Utils.preCastTargetHelper((Level)level, (LivingEntity)caster, (MagicData)playerMagicData, (AbstractSpell)this, (int)30, (float)0.2f);
    }

    public void onServerCastTick(Level level, int spellLevel, LivingEntity caster, @Nullable MagicData playerMagicData) {
        TargetEntityCastData targetData;
        LivingEntity targetEntity;
        assert (playerMagicData != null);
        ICastData iCastData = playerMagicData.getAdditionalCastData();
        if (iCastData instanceof TargetEntityCastData && (targetEntity = (targetData = (TargetEntityCastData)iCastData).getTarget((ServerLevel)level)) != null && targetEntity instanceof LivingEntity) {
            LivingEntity livingTarget = targetEntity;
            livingTarget.m_7292_(new MobEffectInstance((MobEffect)TravelopticsEffects.TIDAL_GRASP_HELPER.get(), 5, 0, false, false, false));
        }
    }

    public void onCast(Level level, int spellLevel, LivingEntity caster, CastSource castSource, MagicData playerMagicData) {
        ICastData iCastData = playerMagicData.getAdditionalCastData();
        if (iCastData instanceof TargetEntityCastData) {
            TargetEntityCastData targetData = (TargetEntityCastData)iCastData;
            LivingEntity targetEntity = targetData.getTarget((ServerLevel)level);
            if (targetEntity != null && targetEntity instanceof LivingEntity) {
                LivingEntity livingTarget = targetEntity;
                Vec3 casterPos = caster.m_20182_();
                Vec3 targetPos = livingTarget.m_20182_();
                Vec3 pullVector = casterPos.m_82546_(targetPos).m_82541_();
                Vec3 newTargetPos = casterPos.m_82546_(pullVector.m_82490_(2.0));
                livingTarget.m_7292_(new MobEffectInstance((MobEffect)TravelopticsEffects.TIDAL_GRASP_HELPER.get(), 15, 0));
                livingTarget.m_6021_(newTargetPos.f_82479_, newTargetPos.f_82480_, newTargetPos.f_82481_);
            }
            caster.m_7292_(new MobEffectInstance((MobEffect)TravelopticsEffects.TIDAL_GRASP.get(), 13, this.getDamage(spellLevel, caster), false, false, false));
        }
        super.onCast(level, spellLevel, caster, castSource, playerMagicData);
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.traveloptics.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)1)}), Component.m_237110_((String)"ui.traveloptics.stun_length", (Object[])new Object[]{Utils.timeFromTicks((float)60.0f, (int)1)}), Component.m_237110_((String)"ui.traveloptics.range", (Object[])new Object[]{Utils.stringTruncation((double)30.0, (int)2)}), Component.m_237113_((String)"\u00a79T.O Magic 'n Extras"));
    }

    private int getDamage(int spellLevel, LivingEntity caster) {
        return (int)(10.0 + (double)this.getSpellPower(spellLevel, (Entity)caster) * 3.0);
    }

    public boolean stopSoundOnCancel() {
        return true;
    }
}

