/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.spells.aqua;

import com.gametechbc.traveloptics.api.init.TravelopticsSchools;
import com.gametechbc.traveloptics.entity.extended_projectiles.ExtendedWaterBoltEntity;
import com.gametechbc.traveloptics.init.TravelopticsEffects;
import com.gametechbc.traveloptics.init.TravelopticsEntities;
import com.gametechbc.traveloptics.init.TravelopticsSounds;
import com.gametechbc.traveloptics.spells.TravelopticsSpellAnimations;
import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import com.github.alexmodguy.alexscaves.server.entity.item.WaterBoltEntity;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class AquaMissilesSpell
extends AbstractSpell {
    private boolean lastOffsetLeft = true;
    private final ResourceLocation spellId = new ResourceLocation("traveloptics", "aqua_missiles");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(TravelopticsSchools.AQUA_RESOURCE).setMaxLevel(5).setCooldownSeconds(25.0).build();

    public AquaMissilesSpell() {
        this.baseManaCost = 5;
        this.manaCostPerLevel = 3;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 140;
    }

    public CastType getCastType() {
        return CastType.CONTINUOUS;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.empty();
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    public AnimationHolder getCastStartAnimation() {
        return TravelopticsSpellAnimations.AQUA_MISSILES_LOOP;
    }

    public void onCast(Level world, int spellLevel, LivingEntity caster, CastSource castSource, MagicData playerMagicData) {
        super.onCast(world, spellLevel, caster, castSource, playerMagicData);
    }

    public void onServerCastTick(Level level, int spellLevel, LivingEntity caster, @Nullable MagicData playerMagicData) {
        if (playerMagicData != null && (playerMagicData.getCastDurationRemaining() + 1) % 3 == 0) {
            caster.m_7292_(new MobEffectInstance((MobEffect)TravelopticsEffects.HOVERING_EFFECT.get(), 5, 1, false, false, false));
            ScreenShake_Entity.ScreenShake((Level)level, (Vec3)caster.m_20182_(), (float)8.0f, (float)0.012f, (int)2, (int)3);
            double dist = this.getSeekingDistance(spellLevel);
            Entity randomlyValid = AquaMissilesSpell.getRandomlyLookingAtEntityFor(level, caster, dist);
            ExtendedWaterBoltEntity bolt = new ExtendedWaterBoltEntity((EntityType<? extends WaterBoltEntity>)((EntityType)TravelopticsEntities.EXTENDED_WATER_BOLT.get()), level);
            double offsetDirection = this.lastOffsetLeft ? -0.72 : 0.72;
            this.lastOffsetLeft = !this.lastOffsetLeft;
            double offsetX = offsetDirection * (double)Mth.m_14089_((float)(caster.m_146908_() * ((float)Math.PI / 180)));
            double offsetZ = offsetDirection * (double)Mth.m_14031_((float)(caster.m_146908_() * ((float)Math.PI / 180)));
            bolt.m_6034_(caster.m_20185_() + offsetX, caster.m_20188_() - (double)0.4f, caster.m_20189_() + offsetZ);
            bolt.m_5602_((Entity)caster);
            bolt.m_37251_((Entity)caster, caster.m_146909_(), caster.m_146908_(), -20.0f, 2.0f, 12.0f);
            bolt.seekAmount = 0.6f;
            if (randomlyValid != null) {
                bolt.setArcingTowards(randomlyValid.m_20148_());
            }
            bolt.setAoeRadius(this.getAoeRadius());
            bolt.setAoeDamageAmount(this.getDamage(spellLevel, caster));
            level.m_7967_((Entity)bolt);
        }
        if (playerMagicData != null && (playerMagicData.getCastDurationRemaining() + 1) % 6 == 0) {
            level.m_6263_(null, caster.m_20185_(), caster.m_20186_(), caster.m_20189_(), (SoundEvent)TravelopticsSounds.AQUA_MISSILES_CAST.get(), SoundSource.NEUTRAL, 1.5f, 1.0f);
        }
    }

    public static Entity getRandomlyLookingAtEntityFor(Level level, LivingEntity caster, double dist) {
        ArrayList<Entity> validEntities = new ArrayList<Entity>();
        Vec3 playerEyes = caster.m_20299_(1.0f);
        BlockHitResult hitresult = level.m_45547_(new ClipContext(playerEyes, playerEyes.m_82549_(caster.m_20154_().m_82490_(dist)), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)caster));
        if (hitresult instanceof EntityHitResult) {
            Entity entity = ((EntityHitResult)hitresult).m_82443_();
            if (!entity.equals((Object)caster) && !caster.m_7307_(entity) && !entity.m_7307_((Entity)caster) && entity instanceof Mob && caster.m_142582_(entity)) {
                validEntities.add(entity);
            }
        } else {
            Vec3 at = hitresult.m_82450_();
            AABB searchArea = new AABB(at.m_82520_(-0.5, -0.5, -0.5), at.m_82520_(0.5, 0.5, 0.5)).m_82400_(15.0);
            for (Entity entity : level.m_45976_(LivingEntity.class, searchArea.m_82400_(dist))) {
                if (entity.equals((Object)caster) || caster.m_7307_(entity) || entity.m_7307_((Entity)caster) || !(entity instanceof Mob) || !caster.m_142582_(entity)) continue;
                validEntities.add(entity);
            }
        }
        validEntities.sort(Comparator.comparingDouble(e -> e.m_20280_((Entity)caster)));
        if (!validEntities.isEmpty()) {
            int limit = Math.min(5, validEntities.size());
            return (Entity)validEntities.get(level.f_46441_.m_188503_(limit));
        }
        return null;
    }

    public float getDamage(int spellLevel, LivingEntity caster) {
        return 4.0f + this.getSpellPower(spellLevel, (Entity)caster) * 1.5f;
    }

    public double getSeekingDistance(int spellLevel) {
        return 15 + spellLevel * 5;
    }

    public float getAoeRadius() {
        return 3.0f;
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.traveloptics.seeking_distance", (Object[])new Object[]{Utils.stringTruncation((double)this.getSeekingDistance(spellLevel), (int)2)}), Component.m_237110_((String)"ui.traveloptics.aoe_radius", (Object[])new Object[]{Utils.stringTruncation((double)this.getAoeRadius(), (int)2)}), Component.m_237110_((String)"ui.traveloptics.aoe_damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)2)}), Component.m_237113_((String)"\u00a79T.O Magic 'n Extras"));
    }
}

