/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.entity.extended_projectiles;

import com.gametechbc.traveloptics.init.TravelopticsEffects;
import com.gametechbc.traveloptics.init.TravelopticsEntities;
import com.gametechbc.traveloptics.init.TravelopticsSpells;
import com.github.alexmodguy.alexscaves.server.entity.item.WaveEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.DeepOneBaseEntity;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.damage.DamageSources;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.PlayMessages;

public class ExtendedWaveEntity
extends WaveEntity {
    private float damageAmount;
    private int wetAmplifier = 0;

    public ExtendedWaveEntity(EntityType<? extends WaveEntity> entityType, Level level) {
        super(entityType, level);
    }

    public ExtendedWaveEntity(Level level, LivingEntity shooter) {
        super(level, shooter);
    }

    public ExtendedWaveEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        super((EntityType)TravelopticsEntities.EXTENDED_WAVE.get(), level);
    }

    public void setDamageAmount(float damageAmount) {
        this.damageAmount = damageAmount;
    }

    public float getDamageAmount() {
        return this.damageAmount;
    }

    public int getWetAmplifier() {
        return this.wetAmplifier;
    }

    public void setWetAmplifier(int wetAmplifier) {
        this.wetAmplifier = wetAmplifier;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.modifiedAttackEntities();
        }
    }

    private void modifiedAttackEntities() {
        AABB bashBox = this.m_20191_().m_82377_(0.5, 0.5, 0.5);
        for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, bashBox)) {
            if (this.m_7307_((Entity)entity) || entity instanceof DeepOneBaseEntity || this.getOwner() != null && (this.getOwner().equals((Object)entity) || this.getOwner().m_7307_((Entity)entity))) continue;
            DamageSources.applyDamage((Entity)entity, (float)this.getDamageAmount(), (DamageSource)((AbstractSpell)TravelopticsSpells.FLOODGATE_SPELL.get()).getDamageSource((Entity)this, (Entity)this.getOwner()));
            entity.m_7292_(new MobEffectInstance((MobEffect)TravelopticsEffects.WET.get(), 200, this.getWetAmplifier()));
        }
    }

    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("DamageAmount")) {
            this.damageAmount = tag.m_128457_("DamageAmount");
        }
        if (tag.m_128425_("WetAmplifier", 3)) {
            this.wetAmplifier = tag.m_128451_("WetAmplifier");
        }
    }

    protected void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128350_("DamageAmount", this.damageAmount);
        compoundTag.m_128405_("WetAmplifier", this.wetAmplifier);
    }
}

