/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.data_manager;

import com.gametechbc.traveloptics.api.particle.ParticleDirection;
import com.gametechbc.traveloptics.api.particle.SphereParticleManager;
import com.github.L_Ender.cataclysm.init.ModParticle;
import com.github.L_Ender.cataclysm.init.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class PhantomRageManager {
    public static final int MAX_RAGE_POINTS = 350;

    public static int getPhantomRage(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("PhantomRage")) {
            return stack.m_41783_().m_128451_("PhantomRage");
        }
        return 0;
    }

    public static void setPhantomRage(ItemStack stack, int points) {
        int cappedPoints = Math.min(points, 350);
        stack.m_41784_().m_128405_("PhantomRage", cappedPoints);
    }

    public static void addPhantomRage(ItemStack stack, Player player, int amount) {
        int currentPoints = PhantomRageManager.getPhantomRage(stack);
        int newPoints = Math.min(currentPoints + amount, 350);
        PhantomRageManager.setPhantomRage(stack, newPoints);
        PhantomRageManager.playSoundOnThreshold(player, currentPoints, newPoints);
        PhantomRageManager.spawnParticlesOnThreshold(player, currentPoints, newPoints);
    }

    private static void displayActionBar(Player player, int points) {
        if (player instanceof ServerPlayer) {
            MutableComponent message = points >= 350 ? Component.m_237113_((String)("\ud83d\udca2 Phantom Rage: " + points)).m_130938_(style -> style.m_178520_(16770714)).m_130940_(ChatFormatting.BOLD) : Component.m_237113_((String)("\ud83d\udca2 Phantom Rage: " + points)).m_130938_(style -> style.m_178520_(7733218));
            player.m_5661_((Component)message, true);
        }
    }

    private static void playSoundOnThreshold(Player player, int oldPoints, int newPoints) {
        if (player.m_9236_().m_5776_()) {
            return;
        }
        if (newPoints >= 350 && oldPoints < 350) {
            player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.MALEDICTUS_BATTLE_CRY.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        } else if (newPoints >= 230 && oldPoints < 230) {
            player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.MALEDICTUS_HURT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        } else if (newPoints >= 115 && oldPoints < 115) {
            player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.MALEDICTUS_HURT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    private static void spawnParticlesOnThreshold(Player player, int oldPoints, int newPoints) {
        if (newPoints >= 350 && oldPoints < 350) {
            Vec3 playerPosition = player.m_20182_();
            SphereParticleManager.spawnParticles(player.m_9236_(), (LivingEntity)player, 50, (ParticleOptions)ModParticle.PHANTOM_WING_FLAME.get(), ParticleDirection.OUTWARD, 4.0);
        }
    }
}

