/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.api.utils;

import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityUtils {
    public static boolean isValidTarget(LivingEntity entity) {
        return entity != null && entity.m_6084_() && !entity.m_213877_();
    }

    public static double getEntitySpeed(LivingEntity entity) {
        return entity.m_21133_(Attributes.f_22279_);
    }

    public static void applyKnockback(Entity entity, Vec3 direction, double strength, boolean hurtMarked) {
        Vec3 knockback = direction.m_82541_().m_82490_(strength);
        entity.m_20256_(knockback);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.f_19864_ = hurtMarked;
        }
    }

    public static double getSquaredDistance(Entity entity1, Entity entity2) {
        return entity1.m_20182_().m_82557_(entity2.m_20182_());
    }

    public static boolean isMobTargetingPlayer(Mob mob, Player player) {
        return mob.m_5448_() == player;
    }

    public static boolean isMoving(Entity entity) {
        Vec3 velocity = entity.m_20184_();
        return velocity.f_82479_ != 0.0 || velocity.f_82480_ != 0.0 || velocity.f_82481_ != 0.0;
    }

    public static void applyDirectionalBoost(Entity entity, double strength, boolean hurtMarked) {
        Vec3 lookDirection = entity.m_20154_().m_82541_().m_82490_(strength);
        entity.m_20256_(lookDirection);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.f_19864_ = hurtMarked;
        }
    }

    public static void applyFriction(Entity entity, double friction) {
        Vec3 velocity = entity.m_20184_().m_82490_(friction);
        entity.m_20256_(velocity);
    }

    public static void instantKill(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.m_6469_(entity.m_269291_().m_269425_(), Float.MAX_VALUE);
        } else {
            entity.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public static boolean isAirborne(Entity entity) {
        return !entity.m_20096_() && !entity.m_20069_();
    }

    public static float getDamageReduction(LivingEntity entity) {
        float armor = (float)entity.m_21133_(Attributes.f_22284_);
        float toughness = (float)entity.m_21133_(Attributes.f_22285_);
        return armor + toughness * 0.5f;
    }

    public static void makeInvisible(LivingEntity entity, int durationTicks) {
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19609_, durationTicks, 0, false, false));
    }

    public static void forceDropHeldItem(LivingEntity entity) {
        for (ItemStack stack : entity.m_6167_()) {
            entity.m_19983_(stack);
        }
        entity.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        entity.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
    }

    public static void pullEntityTowards(Entity entity, Vec3 target, double speed) {
        Vec3 motion = target.m_82546_(entity.m_20182_()).m_82541_().m_82490_(speed);
        entity.m_20256_(motion);
    }

    public static LivingEntity findClosestHostile(LivingEntity entity, double range) {
        AABB boundingBox = entity.m_20191_().m_82400_(range);
        List entities = entity.m_9236_().m_6443_(LivingEntity.class, boundingBox, target -> target != entity && target.m_6084_() && !target.m_7307_((Entity)entity));
        return entities.stream().min(Comparator.comparingDouble(arg_0 -> ((LivingEntity)entity).m_20280_(arg_0))).orElse(null);
    }

    public static <T extends Entity> List<T> getEntitiesInRange(Entity entity, Class<T> entityType, double range) {
        AABB boundingBox = entity.m_20191_().m_82400_(range);
        return entity.m_9236_().m_45976_(entityType, boundingBox);
    }

    public static List<LivingEntity> getEntitiesMatching(Entity entity, double range, Predicate<LivingEntity> filter) {
        AABB boundingBox = entity.m_20191_().m_82400_(range);
        return entity.m_9236_().m_6443_(LivingEntity.class, boundingBox, filter);
    }

    public static LivingEntity findStrongestEntity(Entity entity, double range) {
        AABB boundingBox = entity.m_20191_().m_82400_(range);
        return entity.m_9236_().m_45976_(LivingEntity.class, boundingBox).stream().max(Comparator.comparingDouble(LivingEntity::m_21223_)).orElse(null);
    }

    public static LivingEntity findWeakestEntity(Entity entity, double range) {
        AABB boundingBox = entity.m_20191_().m_82400_(range);
        return entity.m_9236_().m_45976_(LivingEntity.class, boundingBox).stream().min(Comparator.comparingDouble(LivingEntity::m_21223_)).orElse(null);
    }

    public static void launchRandomly(Entity entity, double speed) {
        double randomX = (Math.random() - 0.5) * speed;
        double randomY = Math.random() * speed;
        double randomZ = (Math.random() - 0.5) * speed;
        entity.m_20256_(new Vec3(randomX, randomY, randomZ));
    }

    public static void applySpin(Entity entity, float spinSpeed) {
        entity.m_146922_(entity.m_146908_() + spinSpeed);
    }

    public static void maintainHeight(Entity entity, double targetHeight, double hoverStrength) {
        double currentHeight = entity.m_20186_();
        double difference = targetHeight - currentHeight;
        if (Math.abs(difference) > 0.1) {
            entity.m_20256_(entity.m_20184_().m_82520_(0.0, difference * hoverStrength, 0.0));
        }
    }
}

