/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.api.render;

import com.mojang.blaze3d.pipeline.RenderCall;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.metadata.texture.TextureMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLib;
import software.bernie.geckolib.cache.texture.GeoAbstractTexture;
import software.bernie.geckolib.resource.GeoGlowingTextureMeta;

public class EmissiveTexture
extends GeoAbstractTexture {
    private static final RenderStateShard.ShaderStateShard SHADER_STATE = new RenderStateShard.ShaderStateShard(GameRenderer::m_234223_);
    private static final RenderStateShard.TransparencyStateShard NO_TRANSPARENCY_STATE = new RenderStateShard.TransparencyStateShard("no_transparency", RenderSystem::disableBlend, RenderSystem::defaultBlendFunc);
    private static final RenderStateShard.WriteMaskStateShard WRITE_MASK = new RenderStateShard.WriteMaskStateShard(true, true);
    private static final Function<ResourceLocation, RenderType> RENDER_TYPE_FUNCTION = Util.m_143827_(texture -> {
        RenderStateShard.TextureStateShard textureState = new RenderStateShard.TextureStateShard(texture, false, false);
        return RenderType.m_173215_((String)"geo_glowing_layer", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(SHADER_STATE).m_173290_((RenderStateShard.EmptyTextureStateShard)textureState).m_110685_(NO_TRANSPARENCY_STATE).m_110687_(WRITE_MASK).m_110691_(false));
    });
    private static final String APPENDIX = "_layer";
    protected final ResourceLocation textureBase;
    protected final ResourceLocation glowLayer;

    public EmissiveTexture(ResourceLocation originalLocation, ResourceLocation location) {
        this.textureBase = originalLocation;
        this.glowLayer = location;
    }

    private static ResourceLocation getEmissiveResource(ResourceLocation baseResource) {
        ResourceLocation path = EmissiveTexture.appendToPath((ResourceLocation)baseResource, (String)APPENDIX);
        EmissiveTexture.generateTexture((ResourceLocation)path, textureManager -> textureManager.m_118495_(path, (AbstractTexture)new EmissiveTexture(baseResource, path)));
        return path;
    }

    @Nullable
    protected RenderCall loadTexture(ResourceManager resourceManager, Minecraft mc) throws IOException {
        NativeImage nativeImage;
        AbstractTexture originalTexture;
        try {
            originalTexture = (AbstractTexture)mc.m_18691_(() -> mc.m_91097_().m_118506_(this.textureBase)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException("Failed to load original texture: " + this.textureBase, e);
        }
        Resource textureBaseResource = (Resource)resourceManager.m_213713_(this.textureBase).get();
        if (originalTexture instanceof DynamicTexture) {
            DynamicTexture dynamicTexture = (DynamicTexture)originalTexture;
            nativeImage = dynamicTexture.m_117991_();
        } else {
            nativeImage = NativeImage.m_85058_((InputStream)textureBaseResource.m_215507_());
        }
        NativeImage baseImage = nativeImage;
        NativeImage glowImage = null;
        Optional textureBaseMeta = textureBaseResource.m_215509_().m_214059_((MetadataSectionSerializer)TextureMetadataSection.f_119108_);
        boolean blur = textureBaseMeta.isPresent() && ((TextureMetadataSection)textureBaseMeta.get()).m_119115_();
        boolean clamp = textureBaseMeta.isPresent() && ((TextureMetadataSection)textureBaseMeta.get()).m_119116_();
        try {
            Optional glowLayerResource = resourceManager.m_213713_(this.glowLayer);
            GeoGlowingTextureMeta glowLayerMeta = null;
            if (glowLayerResource.isPresent()) {
                glowImage = NativeImage.m_85058_((InputStream)((Resource)glowLayerResource.get()).m_215507_());
                glowLayerMeta = GeoGlowingTextureMeta.fromExistingImage((NativeImage)glowImage);
            } else {
                Optional meta = textureBaseResource.m_215509_().m_214059_(GeoGlowingTextureMeta.DESERIALIZER);
                if (meta.isPresent()) {
                    glowLayerMeta = (GeoGlowingTextureMeta)meta.get();
                    glowImage = new NativeImage(baseImage.m_84982_(), baseImage.m_85084_(), true);
                }
            }
            if (glowLayerMeta != null) {
                glowLayerMeta.createImageMask(baseImage, glowImage);
                if (!FMLEnvironment.production) {
                    this.printDebugImageToDisk(this.textureBase, baseImage);
                    this.printDebugImageToDisk(this.glowLayer, glowImage);
                }
            }
        }
        catch (IOException e) {
            GeckoLib.LOGGER.warn("Resource failed to open for glowlayer meta: {}", (Object)this.glowLayer, (Object)e);
        }
        NativeImage mask = glowImage;
        if (mask == null) {
            return null;
        }
        return () -> {
            EmissiveTexture.uploadSimple((int)this.m_117963_(), (NativeImage)mask, (boolean)blur, (boolean)clamp);
            if (originalTexture instanceof DynamicTexture) {
                DynamicTexture dynamicTexture = (DynamicTexture)originalTexture;
                dynamicTexture.m_117985_();
            } else {
                EmissiveTexture.uploadSimple((int)originalTexture.m_117963_(), (NativeImage)baseImage, (boolean)blur, (boolean)clamp);
            }
        };
    }

    public static RenderType getRenderType(ResourceLocation texture) {
        return RENDER_TYPE_FUNCTION.apply(EmissiveTexture.getEmissiveResource(texture));
    }
}

