/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.api.entity.ai;

import java.util.EnumSet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;

public class WizardMeleeAttackGoal
extends Goal {
    protected final PathfinderMob mob;
    private final double speedModifier;
    private final double meleeRangeSqr;
    private int ticksUntilNextAttack;
    private final int cooldownTicks;

    public WizardMeleeAttackGoal(PathfinderMob mob, double speedModifier, double meleeRange, int cooldownTicks) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.meleeRangeSqr = meleeRange * meleeRange;
        this.cooldownTicks = cooldownTicks;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity target = this.mob.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        double distanceToTargetSqr = this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
        return distanceToTargetSqr <= this.meleeRangeSqr && this.ticksUntilNextAttack <= 0;
    }

    public boolean m_8045_() {
        return false;
    }

    public void m_8056_() {
        LivingEntity target = this.mob.m_5448_();
        if (target != null) {
            this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            this.mob.m_21573_().m_5624_((Entity)target, this.speedModifier);
            this.mob.m_21011_(InteractionHand.MAIN_HAND, true);
            this.mob.m_7327_((Entity)target);
            this.resetAttackCooldown();
        }
    }

    public void m_8041_() {
        this.mob.m_21573_().m_26573_();
    }

    public void m_8037_() {
        --this.ticksUntilNextAttack;
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.cooldownTicks;
    }
}

